package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockDao;
import cn.com.duiba.goods.center.biz.entity.PreStockEntity;

/**
 * 
 * PreStockDaoImpl
 *
 */
@Repository
public class PreStockDaoImpl extends BaseCreditsDao implements PreStockDao {

	private String stockIdKey = "stockId";
	
	@Override
	public PreStockEntity find(Long id) {
		Map<String, Object> params = new HashMap<>();
		params.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), params);
	}

	@Override
	public PreStockEntity findByPointId(Long pointId) {
		Map<String, Object> params = new HashMap<>();
		params.put("pointId", pointId);
		return getSqlSession().selectOne(getStamentNameSpace("findByPointId"), params);
	}

	@Override
	public PreStockEntity newStock(PreStockEntity stock) {
		int ret = getSqlSession().insert(getStamentNameSpace("insert"), stock);
		if (ret == 1) {
			return stock;
		}
		return null;
	}

	@Override
	public boolean addQuantity(Long stockId, long quantity) {
		Map<String, Object> params = new HashMap<>();
		params.put(stockIdKey, stockId);
		params.put("quantity", quantity);
		int ret = getSqlSession().update(getStamentNameSpace("addQuantity"), params);
		if (ret == 1) {
			return true;
		}
		return false;
	}

	@Override
	public boolean reduceQuantity(Long stockId, long quantity) {
		Map<String, Object> params = new HashMap<>();
		params.put(stockIdKey, stockId);
		params.put("quantity", quantity);
		int ret = getSqlSession().update(getStamentNameSpace("reduceQuantity"), params);
		if (ret == 1) {
			return true;
		}
		return false;
	}

	@Override
	public PreStockEntity lock4update(Long stockId) {
		Map<String, Object> params = new HashMap<>();
		params.put(stockIdKey, stockId);
		return getSqlSession().selectOne(getStamentNameSpace("lock4update"), params);
	}

	@Override
	public List<PreStockEntity> findAllByPointIds(List<Long> pointIds) {
		Map<String, Object> params = new HashMap<>();
		params.put("pointIds", pointIds);
		return getSqlSession().selectList(getStamentNameSpace("findAllByPointIds"), params);
	}

}
