/**
 * Project Name:goods-center-biz File Name:RemoteAdvertCouponGoodsBackendServiceImpl.java Package
 * Name:cn.com.duiba.goods.center.biz.remoteservice.impl Date:2016年7月13日下午8:30:42 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.Date;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import org.slf4j.LoggerFactory;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteAdvertCouponGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.AdvertCouponGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ChangeACGTypeDto;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.service.AdvertCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdvertCouponGoodsBackendServiceImpl <br/>
 * Function: 广告优惠卷商品Service实现类. <br/>
 * Date: 2016年7月13日 下午8:30:42 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@Service("remoteAdvertCouponGoodsBackendService")
public class RemoteAdvertCouponGoodsBackendServiceImpl implements RemoteAdvertCouponGoodsBackendService {

    private  static final Logger             LOGGER = LoggerFactory.getLogger(RemoteAdvertCouponGoodsBackendServiceImpl.class);

    @Autowired
    private AdvertCouponGoodsService        advertCouponGoodsService;
    @Autowired
    private GoodsContentService             goodsContentService;
    @Autowired
    private GoodsBatchService               goodsBatchService;
    @Autowired
    private RemoteGoodsCouponBackendService remoteGoodsCouponBackendService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    
    @Override
    public DubboResult<Boolean> createAdvertCouponGoods(AdvertCouponGoodsDto goods) {
        try {
            if (advertCouponGoodsService.insert(goods)) {
                goodsContentService.add(GoodsTypeEnum.ADVERT, goods.getAcgId(), goods.getCouponRemark(),
                                        goods.getExchangeTips());
            }

            return DubboResult.successResult(true);
        } catch (Exception e) {
            LOGGER.error("createAdvertCouponGoods failed, the req=[{}]", goods, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> editAdvertCouponGoods(Long acgId, AdvertCouponGoodsDto goods) {
        try {
            if (advertCouponGoodsService.update(goods)) {
                goodsContentService.update(GoodsTypeEnum.ADVERT, goods.getAcgId(), goods.getCouponRemark(),
                                           goods.getExchangeTips());
            }

            return DubboResult.successResult(true);
        } catch (Exception e) {
            LOGGER.error("editAdvertCouponGoods failed, the req=[{}]", goods, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteGoods(Long acgId) {
        try {
            return DubboResult.successResult(advertCouponGoodsService.delete(acgId));

        } catch (Exception e) {
            LOGGER.error("deleteGoods failed, the req=[{}]", acgId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<AdvertCouponGoodsDto> find(Long acgId) {
        try {
            AdvertCouponGoodsDto couponGoods = advertCouponGoodsService.select(acgId);
            GoodsContentEntity content = goodsContentService.findByGoods(GoodsTypeEnum.ADVERT, acgId);
            if (content != null) {
                couponGoods.setCouponRemark(content.getContent());
                couponGoods.setExchangeTips(content.getExchangeTips());
            }

            return DubboResult.successResult(couponGoods);
        } catch (Exception e) {
            LOGGER.error("find failed, the req=[{}]", acgId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> changeACGType(ChangeACGTypeDto changeACGTypeDto) {

        try {
            GoodsTypeEnum gtype = changeACGTypeDto.getGtype();
            long gid = changeACGTypeDto.getAcgId();
            long batchId = changeACGTypeDto.getBatchId();
            int dstType = changeACGTypeDto.getDstType();
            Date start = changeACGTypeDto.getStart();
            Date end = changeACGTypeDto.getEnd();
            
            // 1.删除券码数据
            DubboResult<Boolean> deleteGoodsCouponResult = remoteGoodsCouponBackendService.deleteGoodsCoupon(gtype, gid, batchId);
            if(!deleteGoodsCouponResult.isSuccess()){
                LOGGER.error("remoteGoodsCouponBackendService deleteGoodsCoupon failed");
                return DubboResult.failResult("remoteGoodsCouponBackendService deleteGoodsCoupon failed");
            }
            
            // 2.删除批次
            DubboResult<Boolean> dubboResult = remoteGoodsCouponBackendService.physicalDeleteBatch(gtype, gid, batchId);
            if(!dubboResult.isSuccess() || !dubboResult.getResult()){
                LOGGER.error("remoteGoodsCouponBackendService deleteBatch failed");
                return DubboResult.failResult("remoteGoodsCouponBackendService deleteBatch failed");
            }
            // 2.1.删除缓存中的批次信息
            try{
                redisTemplate.delete("goods-RedisBatchCache-"+gtype.getGtype()+"-"+gid);
            }catch(Exception e){
                LOGGER.error("RedisBatchCache.clearBatchsCache gtype="+gtype.getGtype()+",gid="+gid,e);
            }
            
            // 3.新建批次
            if(ChangeACGTypeDto.NORMAL_TYPE == dstType){
                DubboResult<Long> createNormalBatchResult = remoteGoodsCouponBackendService.createNormalBatch(gtype, gid, start, end);
                if(!createNormalBatchResult.isSuccess() || createNormalBatchResult.getResult() == null){
                    return DubboResult.failResult("remoteGoodsCouponBackendService createNormalBatch failed ");
                }
            }
            
            if(ChangeACGTypeDto.LINK_TYPE == dstType){
                DubboResult<Long> createNormalBatchResult = remoteGoodsCouponBackendService.createLinkBatch(gtype, gid, start, end, changeACGTypeDto.getLink(), changeACGTypeDto.getStock());
                if(!createNormalBatchResult.isSuccess() || createNormalBatchResult.getResult() == null){
                    LOGGER.error("remoteGoodsCouponBackendService createNormalBatch failed");
                    return DubboResult.failResult("remoteGoodsCouponBackendService createNormalBatch failed");
                }
            }
            
            if(ChangeACGTypeDto.REPEAT_TYPE == dstType){
                DubboResult<Long> createNormalBatchResult = remoteGoodsCouponBackendService.createRepeatBatch(gtype, gid, start, end, changeACGTypeDto.getCode(), changeACGTypeDto.getPassword(), changeACGTypeDto.getStock());
                if(!createNormalBatchResult.isSuccess() || createNormalBatchResult.getResult() == null){
                    LOGGER.error("remoteGoodsCouponBackendService createRepeatBatch failed");
                    return DubboResult.failResult("remoteGoodsCouponBackendService createRepeatBatch failed");
                }
            }
            

            return DubboResult.successResult(true);
        } catch (Exception e) {
            LOGGER.error("changeACGType failed the message=[{}]", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
