package cn.com.duiba.goods.center.biz.remoteservice.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteEverydayLimitService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * RemoteEverydayLimitServiceImpl
 *
 */
@Service("remoteEverydayLimitService")
public class RemoteEverydayLimitServiceImpl implements RemoteEverydayLimitService {

	@Autowired
	private EverydayLimitService everydayLimitService;

	@Override
	public DubboResult<Boolean> everydayLimitCheck(Long appItemId, Long itemId, int limit) {
		boolean ret = everydayLimitService.updateEverydaySales(appItemId, itemId, limit);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Void> rollbackEverydayLimit(Long appItemId, Long itemId) {
		everydayLimitService.rollbackEverydayLimit(appItemId, itemId);
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<Integer> findEverydayLimitSales(Long appItemId, Long itemId) {
		Integer ret = everydayLimitService.findEverydayLimitSales(appItemId, itemId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Long> findEverydayLimitStock(ItemKeyDto itemKeyDto) {
		Long ret = everydayLimitService.findEverydayStock(itemKeyDto);
		if (ret == null) {
			return DubboResult.failResult("不是每日限量商品或是每日限制商品限制数为空");
		}
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> decrEverydayLimitStock(ItemKeyDto itemKeyDto) {
		Boolean ret = everydayLimitService.decrEeverydayStock(itemKeyDto);
		if (ret == null) {
			return DubboResult.failResult("不是每日限量商品或是每日限制商品限制数为空");
		}
		return DubboResult.successResult(ret);
	}

}
