/**
 * Project Name:goods-center-biz
 * File Name:RemoteGoodsCouponServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.impl
 * Date:2016年5月24日下午4:21:53
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.impl;


import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

/**
 * ClassName:RemoteGoodsCouponServiceImpl <br/>
 * Date:     2016年5月24日 下午4:21:53 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remoteGoodsCouponService")
public class RemoteGoodsCouponServiceImpl implements RemoteGoodsCouponService{
    private static Logger log=LoggerFactory.getLogger(RemoteGoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId,String bizNum) {
        try{
            DBTimeProfile.enter("RemoteGoodsCouponServiceImpl.takeCoupon");
            GoodsCouponEntity coupon=goodsCouponBO.takeCoupon(gtype, gid, consumerId,bizNum);
            if(coupon==null){
                return DubboResult.successResult(null);
            }
            GoodsCouponDto dto=PCGConvertUtil.convert(coupon);
            GoodsBatchEntity batch=goodsBatchService.find(coupon.getGoodsBatchId());
            dto.setOverDue(batch.getEndDay());
            return DubboResult.successResult(dto);
        }catch(RuntimeGoodsException rge){
            log.error("takeCoupon gtype="+gtype.getGtype()+",gid ="+gid+",consumerId="+consumerId,rge);
            return DubboResult.failResult(rge.getResultMessage());
        }catch(Exception e){
            log.error("takeCoupon gtype="+gtype.getGtype()+", gid="+gid+",consumerId="+consumerId,e);
            return DubboResult.failResult(e.getMessage());
        }finally{
            DBTimeProfile.release();
        }
    }

    @Override
    public DubboResult<Boolean> completeCoupon(Long couponId, long orderId) {
        try{
            goodsCouponBO.completeCoupon(couponId, orderId);
            return DubboResult.successResult(true);
        }catch(Exception e){
            log.error("takeCoupon couponId="+couponId+",orderId="+orderId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> rollbackCoupon(Long couponId,String bizNum) {
        try{
            Boolean ret=goodsCouponBO.rollbackCoupon(couponId,bizNum);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("rollbackCoupon couponId="+couponId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

	@Override
	public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype, long gid, Long couponId) {
		try {
			if (couponId == null || couponId < 1 || String.valueOf(couponId).length() < 4) {
				log.warn("findCoupon： parameter error: gtype=" + gtype.getGtype() + " ,gid=" + gid + ",couponId=" + couponId);
				return null;
			}
			GoodsCouponEntity coupon = goodsCouponBO.findCoupon(couponId);
			GoodsBatchEntity batch = goodsCouponBO.findBatch(coupon.getGoodsBatchId());
			GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
			dto.setStartDay(batch.getStartDay());
			dto.setOverDue(batch.getEndDay());
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			log.error("findCoupon gtype=" + gtype.getGtype() + ",gid= " + gid + ",couponId=" + couponId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> findGoodsStock(GoodsTypeEnum gtype, long gid) {
		try {
			long stock = goodsCouponBO.findGoodsStock(gtype, gid);
			return DubboResult.successResult(stock);
		} catch (Exception e) {
			log.error("findCurrentBacthStock gtype=" + gtype.getGtype() + ",gid=" + gid, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<GoodsStockDto>> findGoodsStockByBatch(List<GoodsStockDto> goods) {
		try {
			List<GoodsStockDto> dtos = goodsCouponBO.findGoodsStockByBatch(goods);
			return DubboResult.successResult(dtos);
		} catch (Exception e) {
			log.error("findCurrentBatchStockByBatch", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<GoodsBatchDto> findUsingBatch(GoodsTypeEnum gtype, long gid) {
		try {
			GoodsBatchEntity batch = goodsCouponBO.findUsingBatch(gtype, gid);
			if(batch!=null){
				GoodsBatchDto dto = PCGConvertUtil.convert(batch);
				return DubboResult.successResult(dto);
			}
			return DubboResult.failResult("没有使用中的批次");
		} catch (Exception e) {
			log.error("findUsingBatch gtype=" + gtype.getGtype() + ",gid=" + gid, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

    @Override
    public GoodsCouponDto findCoupon(long couponId) {
		if (couponId < 1 || String.valueOf(couponId).length() < 4) {
			log.warn("findCoupon： parameter error: couponId=" + couponId);
			return null;
		}
        GoodsCouponEntity coupon=goodsCouponService.find(couponId);
        long batchId=coupon.getGoodsBatchId();
        GoodsBatchEntity batch=goodsBatchService.find(batchId);
        
        GoodsCouponDto dto=PCGConvertUtil.convert(coupon);
        dto.setOverDue(batch.getEndDay());
        return dto;
    }

	@Override
	public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum) {
		try {
			DBTimeProfile.enter("takeCoupon");
			GoodsCouponEntity coupon = goodsCouponBO.takeCoupon(gtype, gid, consumerId, appId, bizNum);
			if (coupon == null) {
				return DubboResult.successResult(null);
			}
			GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
			GoodsBatchEntity batch = goodsBatchService.find(coupon.getGoodsBatchId());
			dto.setOverDue(batch.getEndDay());
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			log.error("takeCoupon gtype=" + gtype.getGtype() + ", gid=" + gid + ",consumerId=" + consumerId + ",appId=" + appId + ",bizNum=" + bizNum, e);
			return DubboResult.failResult(e.getMessage());
		} finally {
			DBTimeProfile.release();
		}
	}

	@Override
	public DubboResult<GoodsCouponDto> findCouponById(Long couponId) {
		try {
			if (couponId == null || couponId < 1 || String.valueOf(couponId).length() < 4) {
				log.warn("findCoupon： parameter error couponId=" + couponId);
				return DubboResult.failResult("请求参数错误");
			}
			GoodsCouponEntity coupon = goodsCouponService.find(couponId);
			if(coupon == null){
				return DubboResult.successResult(null);
			}
			long batchId = coupon.getGoodsBatchId();
			GoodsBatchEntity batch = goodsBatchService.find(batchId);
			GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
			dto.setOverDue(batch.getEndDay());
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			log.error("findCouponById： parameter error couponId=" + couponId, e);
			return DubboResult.failResult(e.getMessage());
		} finally {
			DBTimeProfile.release();
		}
	}
}

