package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.List;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.slf4j.LoggerFactory;
import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteItemGoodsService;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * Created by gyf . 16/10/17 .
 */
@Service("remoteItemGoodsService")
public class RemoteItemGoodsServiceImpl implements RemoteItemGoodsService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemGoodsServiceImpl.class);

	@Autowired
	private ItemGoodsService itemGoodsService;

	@Override
	public DubboResult<Boolean> checkElasticTakeOrder(Long itemId, Long appId, Long consumerId) {
		try {
			itemGoodsService.checkElasticTakeOrder(itemId, appId, consumerId);
			return DubboResult.successResult(true);
		} catch (Exception e) {
			LOGGER.error("checkElasticTakeOrder ", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<ElasticGiftsItemShowDto>> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId) {
		try {
			List<ElasticGiftsItemShowDto> result = itemGoodsService.getItemsByElItemIds4Mobile(itemIds, appId, consumerId);
			return DubboResult.successResult(result);
		} catch (Exception e) {
			LOGGER.error("getItemsByElItemIds ", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<ItemDto> find(Long itemId) {
		try {
			ItemEntity entity = itemGoodsService.find(itemId);
			ItemDto dto = new ItemDto();
			ObjectUtil.convert(entity, dto);
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			LOGGER.error("find:itemId= " + itemId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> updateEnable(Long itemId, boolean enable) {
		try {
			Boolean ret = itemGoodsService.updateEnable(itemId, enable);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("updateEnable:itemId= " + itemId + " enable=" + enable, e);
			return DubboResult.failResult(e.getMessage());
		}
	}
}
