/**
 * Project Name:goods-center-biz
 * File Name:RemotePCGFilterConfigBackendServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.impl
 * Date:2016年5月26日下午8:24:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemotePCGFilterConfigBackendService;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.*;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * ClassName:RemotePCGFilterConfigBackendServiceImpl <br/>
 * Date:     2016年5月26日 下午8:24:56 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remotePCGFilterConfigBackendService")
public class RemotePCGFilterConfigBackendServiceImpl implements RemotePCGFilterConfigBackendService{

    private static Logger           log = LoggerFactory.getLogger(RemotePCGFilterConfigBackendServiceImpl.class);
    @Autowired
    private PCGFilterConfigService  pCGFilterConfigService;

    @Autowired
    private PCGSellerGoodsService   pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;

    @Override
    public DubboResult<Long> addCategoryBlackList(Long appId, Long categoryId) {
        try {
            Long l = pCGFilterConfigService.insert(appId, PlatformCouponGoodsConstant.PcgFilterConfigCategoryType,
                                                   categoryId);
            return DubboResult.successResult(l);
        } catch (Exception e) {
            log.error("addCategoryBlackList appId=" + appId + ",categoryId=" + categoryId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteCategoryBlackList(Long appId, Long categoryId) {
        try {
            pCGFilterConfigService.delete(appId, PlatformCouponGoodsConstant.PcgFilterConfigCategoryType, categoryId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("deleteCategoryBlackList appId=" + appId + ",categoryId=" + categoryId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Long> addSellerBlackList(Long appId, Long sellerId) {
        try {
            Long l = pCGFilterConfigService.insert(appId, PlatformCouponGoodsConstant.PcgFilterConfigSellerType,
                                                   sellerId);
            return DubboResult.successResult(l);
        } catch (Exception e) {
            log.error("addSellerBlackList appId=" + appId + ",sellerId=" + sellerId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteSellerBlackList(Long appId, Long sellerId) {
        try {
            pCGFilterConfigService.delete(appId, PlatformCouponGoodsConstant.PcgFilterConfigSellerType, sellerId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("deleteSellerBlackList appId=" + appId + ",sellerId=" + sellerId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> addGoodsBlackList(Long appId, Long pcgId) {
        try {
            Long l = pCGFilterConfigService.insert(appId, PlatformCouponGoodsConstant.PcgFilterConfigGoodsType, pcgId);
            return DubboResult.successResult(l);
        } catch (Exception e) {
            log.error("addGoodsBlackList appId=" + appId + ",pcgId=" + pcgId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteGoodsBlackList(Long appId, Long pcgId) {
        try {
            pCGFilterConfigService.delete(appId, PlatformCouponGoodsConstant.PcgFilterConfigGoodsType, pcgId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("deleteGoodsBlackList appId=" + appId + ",pcgId=" + pcgId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGDto>> findGoodsFilterList(Long appId) {
        try {
            List<PCGDto> list = new ArrayList<>();
            List<PlatformCouponGoodsEntity> pcgs = pCGFilterConfigService.findGoodsFilterList(appId);
            pCGFilterConfigService.goodsTagsFilter(pcgs, appId);
            ObjectUtil.convertList(pcgs, list, PCGDto.class);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findGoodsFilterList appId=" + appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGCategoryDto>> findCategoryFilterList(Long appId) {
        try {
            List<PCGCategoryDto> list = new ArrayList<>();
            ObjectUtil.convertList(pCGFilterConfigService.findCategoryFilterList(appId), list, PCGCategoryDto.class);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findCategoryFilterList appId=" + appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGSellerDto>> findSellerFilterList(Long appId) {
        try {
            List<PCGSellerDto> list = new ArrayList<>();
            ObjectUtil.convertList(pCGFilterConfigService.findSellerFilterList(appId), list, PCGSellerDto.class);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findSellerFilterList appId=" + appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGFilterConfigDto>> findCounponBelong(Long goodsId) {
        try {
            List<PCGFilterConfigDto> list = pCGFilterConfigService.findCounponBelong(goodsId);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findCounponBelong goodsId=" + goodsId, e);
            return DubboResult.failResult(e.getMessage());
        }

    }

    @Override
    public DubboResult<List<PCGDto>> findPCGCategorySellerGoodsList(Long appId) {
        return null;

    }

    @Override
    public DubboResult<List<Long>> findPCGFilterTargetIds(Long appId, Integer type) {
        try {
            List<Long> list = pCGFilterConfigService.selectPCGFilterTargetIds(appId, type);
            return DubboResult.successResult(list);
        } catch (Exception e) {
            log.error("findPCGFilterTargetIds appId=" + appId + ",type=" + type, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGCategorySellerGoodsDto>> findPCGCategorySellerGoodsList2(Long appId) {
        try {
            List<PCGCategorySellerGoodsDto> categoryGoodsList = pCGFilterConfigService.selectPCGCategoryGoodsList(appId);
            List<PCGCategorySellerGoodsDto> sellerGoodsList = pCGFilterConfigService.selectPCGSellerGoodsList(appId);
            sellerGoodsList.removeAll(categoryGoodsList);
            sellerGoodsList.addAll(categoryGoodsList);
            Collections.sort(sellerGoodsList);
            return DubboResult.successResult(sellerGoodsList);
        } catch (Exception e) {
            log.error("findPCGCategroySellerGoodsList appId=" + appId, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}

