package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.slf4j.LoggerFactory;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteAppItemGoodsService;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * 
 * RemoteAppItemGoodsServiceImpl
 *
 */
@Service
public class RemoteAppItemGoodsServiceImpl implements RemoteAppItemGoodsService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAppItemGoodsServiceImpl.class);

	@Autowired
	private AppItemService appItemService;

	@Override
	public DubboResult<AppItemDto> find(Long id) {
		try {
			AppItemEntity entity = appItemService.find(id);
			AppItemDto dto = BeanUtils.copy(entity, AppItemDto.class);
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			LOGGER.error("find:" + id, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<AppItemDto>> findByIds(List<Long> ids) {
		try {
			List<AppItemEntity> entitys = appItemService.findByIds(ids);
			List<AppItemDto> dtos = BeanUtils.copyList(entitys, AppItemDto.class);
			return DubboResult.successResult(dtos);
		} catch (Exception e) {
			LOGGER.error("findByIds:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> insert(AppItemDto appItemDto) {
		try {
			AppItemEntity entity = BeanUtils.copy(appItemDto, AppItemEntity.class);
			Long id = appItemService.insert(entity);
			return DubboResult.successResult(id);
		} catch (Exception e) {
			LOGGER.error("insert:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> update(AppItemDto appItemDto) {
		try {
			AppItemEntity entity = BeanUtils.copy(appItemDto, AppItemEntity.class);
			Boolean ret = appItemService.update(entity);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("update:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> delete(Long appId, Long appItemId) {
		try {
			Boolean ret = appItemService.delete(appId, appItemId);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("update:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> deleteByIds(Long appId, List<Long> appItemIds) {
		try {
			Integer ret = appItemService.deleteByIds(appId, appItemIds);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("deleteByIds:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> updateStatus(Long appId, Long appItemId, String status) {
		try {
			Boolean ret = appItemService.updateStatus(appId, appItemId, status);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("updateStatus:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Integer> updateStatusByIds(Long appId, List<Long> appItemIds, String status) {
		try {
			Integer ret = appItemService.updateStatusByIds(appId, appItemIds, status);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("updateStatusByIds:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> appendStock(Long appId, Long appItemId, Long number) {
		try {
			Boolean ret = appItemService.appendStock(appId, appItemId, number);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("appendStock:appId=" + appId + " appItemId=" + appItemId + " number=" + number, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> deductStock(Long appId, Long appItemId, Long number) {
		try {
			Boolean ret = appItemService.deductStock(appId, appItemId, number);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("deductStock:appId=" + appId + " appItemId=" + appItemId + " number=" + number, e);
			return DubboResult.failResult(e.getMessage());
		}
	}
	
	@Override
    public DubboResult<Integer> updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
	    try {
            Integer ret = appItemService.updateStatusByActivityIds(status, delete, oids);
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            LOGGER.error("deductStock:status=" + status + " delete=" + delete + " oids=" + oids, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

	
}
