package cn.com.duiba.goods.center.biz.remoteservice.item;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemCouponGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * RemoteItemCouponGoodsServiceImpl
 *
 */
@Service
public class RemoteItemCouponGoodsServiceImpl implements RemoteItemCouponGoodsService {

	@Autowired
	private ItemCouponGoodsService itemCouponGoodsService;

	@Override
	public DubboResult<GoodsCouponDto> takeCoupon(ItemKeyDto itemKeyDto, Long consumerId, String bizNum) {
		try {
			if (itemKeyDto == null || itemKeyDto.getAppId() == null) {
				return DubboResult.failResult("APPID不能为空");
			}
			if (consumerId == null || StringUtils.isEmpty(bizNum)) {
				return DubboResult.failResult("用户ID或订单号不能为空");
			}
			GoodsCouponDto entity = itemCouponGoodsService.takeCoupon(itemKeyDto, consumerId, bizNum);
			return DubboResult.successResult(entity);
		} catch (Exception e) {
			return DubboResult.failResult("发券失败：" + e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> completeCoupon(ItemKeyDto itemKeyDto, Long couponId, long orderId) {
		Boolean ret = itemCouponGoodsService.completeCoupon(itemKeyDto, couponId, orderId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Boolean> rollbackCoupon(ItemKeyDto itemKeyDto, Long couponId, String bizNum) {
		Boolean ret = itemCouponGoodsService.rollbackCoupon(itemKeyDto, couponId, bizNum);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<GoodsCouponDto> findCoupon(ItemKeyDto itemKeyDto, Long couponId) {
		GoodsCouponDto ret = itemCouponGoodsService.findCoupon(itemKeyDto, couponId);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<GoodsBatchDto> findCurrentBatch(ItemKeyDto itemKeyDto) {
		GoodsBatchDto ret = itemCouponGoodsService.findCurrentBatch(itemKeyDto);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<GoodsBatchDto> findCouponBatch(ItemKeyDto itemKeyDto, Long batchId) {
		GoodsBatchDto ret = itemCouponGoodsService.findCouponBatch(itemKeyDto, batchId);
		return DubboResult.successResult(ret);
	}

}
