package cn.com.duiba.goods.center.biz.service;


import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.cache.IPCache;
import cn.com.duiba.goods.center.biz.entity.IpLibraryEntity;
import cn.com.duiba.service.domain.dataobject.IpLibraryDO;

import java.util.List;

/**
 * 
 * AddrLimitService
 *
 */
public interface AddrLimitService {

	/**
	 * findAddrLimitByAppItemId
	 * @param appItemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId);
	
	/**
	 * findAddrLimitByAppItemIds
	 * @param appItemIds
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds);
	
	/**
	 * findAddrLimitByItemId
	 * @param itemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByItemId(Long itemId);
	
	/**
	 * findAddrLimitByItemIds
	 * @param itemIds
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds);
	
	/**
	 * findTypeByAppItemId
	 * @param appItemId
	 * @return
	 */
	public Integer findTypeByAppItemId(Long appItemId);
	
	/**
	 * findTypeByItemId
	 * @param itemId
	 * @return
	 */
	public Integer findTypeByItemId(Long itemId);
	
	/**
	 * batchInsertAddrLimit
	 * @param addrLimitList
	 */
	public void batchInsertAddrLimit(List<AddrLimitDto> addrLimitList);
	
	/**
	 * deleteAddrLimit
	 * @param itemId
	 * @param appItemId
	 */
	public void deleteAddrLimit(Long itemId, Long appItemId);
	/**
	 * 查询IP
	 * @param ipLong
	 * @return
	 */
	public IPCache findCodeByIpLong(Long ipLong);
}
