package cn.com.duiba.goods.center.biz.service.amb;

import cn.com.duiba.goods.center.biz.entity.amb.AmbOrderFastEntity;

import java.util.Date;

/***
 * 加钱购 定单加速表
 * By Gyf
 */
public interface AmbOrderFastService {

	/**
	 * 待付款 30分钟
	 */
	public int createOrderFastWaitPay(Long mainOrderId, Long consumerId,Long subOrderId,Long appId, Date orderGmtCreate);

	/**
	 * 待收货 7天
	 */
	public int createOrderFastWaitReceive(Long mainOrderId, Long consumerId,Long subOrderId,Long appId);

	/**
	 * 已收货 7天
	 */
	public int createOrderFastReceived(Long mainOrderId, Long consumerId,Long subOrderId,Long appId);

	/**
	 * 待售后 7天
	 */
	public int createOrderFastWaitPostsale(Long mainOrderId, Long consumerId,Long subOrderId,Long appId);

	/**
	 * 同意售后 14天
	 */
	public int createOrderFastAfterAgree(Long mainOrderId, Long consumerId,Long subOrderId,Long appId);

	/**
	 * 订单总时间 60天
	 */
	public int createOrderFastMaxTime(Long mainOrderId, Long consumerId,Long subOrderId,Long appId);

	/**
	 * 删除 待付款 30分钟
	 */
	public int removeOrderFastWaitPay(Long orderId);

	/**
	 * 删除 待收货 7天
	 */
	public int removeOrderFastWaitReceive(Long orderId);

	/**
	 * 删除 已收货 7天
	 */
	public int removeOrderFastReceived(Long orderId);

	/**
	 * 删除 待售后 7天
	 */
	public int removeOrderFastWaitPostsale(Long orderId);

	/**
	 * 删除 同意售后 14天
	 */
	public int removeOrderFastAfterAgree(Long orderId);

	/**
	 * 删除 订单总时间 60天
	 */
	public int removeOrderFastMaxTime(Long orderId);

	/**
	 * 整个订单结束，删除所有加速表任务记录
	 */
	public int removeOrderFastAtFinish(Long orderId);

	/**
	 * 对加速订单上锁
	 */
	public AmbOrderFastEntity lock(Long id);
	
	/**
	 * 根据加速订单类型，和主订单ID，查询
	 */
	public AmbOrderFastEntity findByOrderIdAndType(Long orderId, String type);
	


}
