package cn.com.duiba.goods.center.biz.service.amb.impl;

import cn.com.duiba.goods.center.biz.dao.amb.AmbAlipayPaybackDAO;
import cn.com.duiba.goods.center.biz.dao.amb.AmbPaychannelOrdersDAO;
import cn.com.duiba.goods.center.biz.dao.amb.AmbSubOrdersDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbAlipayPaybackEntity;
import cn.com.duiba.goods.center.biz.entity.amb.AmbPaychannelOrdersEntity;
import cn.com.duiba.goods.center.biz.entity.amb.AmbSubOrdersEntity;
import cn.com.duiba.goods.center.biz.service.amb.AmbAlipayPaybackService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AmbAlipayPaybackServiceImpl implements AmbAlipayPaybackService {
	
	@Autowired
	private AmbAlipayPaybackDAO ambAlipayPaybackDAO;

	@Autowired
	private AmbSubOrdersDAO ambSubOrdersDAO;
	@Autowired
	private AmbPaychannelOrdersDAO ambPaychannelOrdersDAO;

	/**
	 *
	 * @param subOrderId  子订单id
	 * @param consumerId  用户id
	 * @param mainOrderId 主订单Id
     */
	@Override
	public void insert(Long mainOrderId,Long subOrderId, Long consumerId) {
		AmbAlipayPaybackEntity alipayPaybackDO = new AmbAlipayPaybackEntity();

		AmbSubOrdersEntity sub = ambSubOrdersDAO.findSubOrderById(subOrderId);
		AmbPaychannelOrdersEntity ambPaychannelOrdersDO = ambPaychannelOrdersDAO.findById(sub.getAmbPaychannelOrdersId());
		alipayPaybackDO.setOrderId(mainOrderId);
		alipayPaybackDO.setAmbSubOrderId(subOrderId);
		alipayPaybackDO.setAmbPaychannelOrderId(sub.getAmbPaychannelOrdersId());
		alipayPaybackDO.setOrderNum(ambPaychannelOrdersDO.getOrderNum());
		alipayPaybackDO.setTradeNo(ambPaychannelOrdersDO.getTradeNum());
		alipayPaybackDO.setRefundPrice(ambPaychannelOrdersDO.getRefundPrice());
		alipayPaybackDO.setStatus(AmbAlipayPaybackEntity.AlipayPaybackStatusWait);
		ambAlipayPaybackDAO.createAlipayPayBackRecord(alipayPaybackDO);
	}
}
