/**
 * credits AmbExpressTemplateServiceImpl.java
 * 
 * File Created at 2016年1月5日 下午8:36:05
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.goods.center.biz.service.amb.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.amb.ExpressCacheDto;
import cn.com.duiba.goods.center.biz.dao.amb.AmbExpressTemplateDAO;
import cn.com.duiba.goods.center.biz.dao.amb.AmbExpressTemplateOptionDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbExpressTemplateEntity;
import cn.com.duiba.goods.center.biz.entity.amb.AmbExpressTemplateOptionEntity;
import cn.com.duiba.goods.center.biz.service.amb.AmbExpressTemplateService;
import cn.com.duiba.intersection.serivce.api.remoteservice.RemoteProvinceCityCodeService;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.ProvinceCityCodeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import net.rubyeye.xmemcached.MemcachedClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


@Service
public class AmbExpressTemplateServiceImpl implements AmbExpressTemplateService{

    /**
     * 运费模板缓存key
     */
    public static final String MS_EXPRESS_TEMPLATE = "gc_123";
    
    @Autowired
    private AmbExpressTemplateDAO ambExpressTemplateDAO;
    
    @Autowired
    private AmbExpressTemplateOptionDAO ambExpressTemplateOptionDAO;
    
    @Autowired
    private RemoteProvinceCityCodeService remoteProvinceCityCodeService;
    
    @Autowired
    private MemcachedClient memcachedClient;

    /**
     * 获取该模板下所有项的对应关系集
     * @param templateOptionDOs
     * @return
     */
    private Map<String, Long> getCodesAndPriceMatchs(List<AmbExpressTemplateOptionEntity> templateOptionDOs){
        Map<String, Long> map = new HashMap<String, Long>();
        for (AmbExpressTemplateOptionEntity ambExpressTemplateOptionDO : templateOptionDOs) {
            List<String> availableCodes = new ArrayList<String>();
            List<String> cityCodes = Arrays.asList(ambExpressTemplateOptionDO.getCityCode().split(AmbExpressTemplateOptionEntity.CodeSeparators));
            List<String> provinceCodes = Arrays.asList(ambExpressTemplateOptionDO.getProvinceCode().split(AmbExpressTemplateOptionEntity.CodeSeparators));
            for (int i = 0 ;i < cityCodes.size(); i++) {
                if(cityCodes.get(i).equals("all")){
                    availableCodes.add(provinceCodes.get(i));
                }else {
                    availableCodes.add(cityCodes.get(i));
                }
            }
            for (String string : availableCodes) {
                map.put(string, ambExpressTemplateOptionDO.getExpressPrice());
            }
        }
        return map;
    }
    
    /**
     * 运费匹配方法
     * @param addrProvince 省
     * @param addrCity 城市
     * @param addrArea 区
     * @param expressTemplateId
     * @return
     * @throws Exception
     */
    public Long matchExpressPrice(String addrProvince,String addrCity ,String addrArea,Long expressTemplateId) throws Exception{
        Long expressPrice = null;
        String provinceCode = null;
        String cityCode = null;
        
        //根据用户最后填写的收货地址查询省市编码
        boolean isZxs = isZxsProvince(addrProvince);
        if (isZxs) {
            //直辖市
            if(!StringUtils.isBlank(addrProvince)){
                DubboResult result = remoteProvinceCityCodeService.findProvinceByName(addrProvince.substring(0, 2));
                if(result.isSuccess() && null!=result.getResult()){
                    ProvinceCityCodeDto dto= (ProvinceCityCodeDto) result.getResult();
                    provinceCode = dto.getCode();
                    cityCode = dto.getCode();
                }
            }
        }else {
            if(!StringUtils.isBlank(addrProvince)){
                DubboResult result = remoteProvinceCityCodeService.findProvinceByName(addrProvince.substring(0, 2));
                if(result.isSuccess()&& null!=result.getResult()){
                    ProvinceCityCodeDto dto= (ProvinceCityCodeDto) result.getResult();
                    provinceCode = dto.getCode();
                    if(!StringUtils.isBlank(addrCity)){
                        DubboResult ret = remoteProvinceCityCodeService.findByNameAndParentCode(addrCity.substring(0, 2),dto.getCode());
                        if(ret.isSuccess() && null!=ret.getResult()){
                            ProvinceCityCodeDto city= (ProvinceCityCodeDto) result.getResult();
                            cityCode = city != null ? city.getCode() : null;
                        }
                    }
                }
            }
        }
        AmbExpressTemplateEntity expressTemplateDO = ambExpressTemplateDAO.find(expressTemplateId);
        List<AmbExpressTemplateOptionEntity> expressTemplateOptionDOs = ambExpressTemplateOptionDAO.findByTemplateId(expressTemplateId);

        if(expressTemplateDO != null && expressTemplateOptionDOs != null){
            if(cityCode != null && provinceCode != null){
                    String str = String.valueOf(memcachedClient.get(getExpressTemplateKey(expressTemplateDO.getId())));
                    ExpressCacheDto cacheVO = JSONObject.parseObject(str, ExpressCacheDto.class);
                Map<String, Long> matchs =new HashMap<>();
                if(cacheVO == null || !cacheVO.getGmtModified().equals(expressTemplateDO.getGmtModified())){
                    matchs = getCodesAndPriceMatchs(expressTemplateOptionDOs);
                    cacheVO = new ExpressCacheDto();
                    cacheVO.setGmtModified(expressTemplateDO.getGmtModified());
                    cacheVO.setMatchs(matchs);
                    //将匹配项放和缓存
                    memcachedClient.set(getExpressTemplateKey(expressTemplateDO.getId()), 60 * 60, JSONObject.toJSONString(cacheVO));
                }else {
                    matchs = cacheVO.getMatchs();
                }
                Long temp = matchs.get(cityCode);
                expressPrice = temp == null ? matchs.get(provinceCode) : temp;
            }
            return expressPrice != null ? expressPrice : expressTemplateDO.getDefaultExpressPrice();
        }else{
            throw new Exception("运费模板不存在，匹配失败！");
        }
    }
    
    
    
    /**
     * 获取默认运费
     * @param expressTemplateId
     * @return
     */
    public Long getDefaultPrice(Long expressTemplateId) {
        return ambExpressTemplateDAO.find(expressTemplateId).getDefaultExpressPrice();
    }
    
    private String getExpressTemplateKey(Long expressTemplateId){
        return MS_EXPRESS_TEMPLATE+"-"+expressTemplateId;
    }
    
    public static boolean isZxsProvince(String province){
        if(StringUtils.isNotBlank(province)) {
            if(Arrays.asList("北京市","上海市","天津市","重庆市").contains(province.trim())){
                return true;
            }
        }
        return false;
    }
}
