package cn.com.duiba.goods.center.biz.service.amb.impl;

import cn.com.duiba.goods.center.biz.dao.amb.AmbOrderFastDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbOrderFastEntity;
import cn.com.duiba.goods.center.biz.service.amb.AmbOrderFastService;
import cn.com.duiba.goods.center.biz.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class AmbOrderFastServiceImpl implements AmbOrderFastService {

	@Autowired
	private AmbOrderFastDAO ambOrderFastDAO;

	
	@Override
	public int createOrderFastWaitPay(Long mainOrderId, Long consumerId,Long subOrderId,Long appId, Date orderGmtCreate) {
		Date scanTime = DateUtil.minutesAddOrSub(orderGmtCreate, AmbOrderFastEntity.ScanTime30Minute);
		return innerCreateOrderFast(mainOrderId, consumerId, subOrderId,appId,AmbOrderFastEntity.OrderFastTypeWaitPay, scanTime);
	}

	@Override
	public int createOrderFastWaitReceive(Long mainOrderId, Long consumerId,Long subOrderId,Long appId) {
		Date scanTime = DateUtil.daysAddOrSub(new Date(), AmbOrderFastEntity.ScanTime7Day);
		return innerCreateOrderFast(mainOrderId, consumerId,subOrderId,appId, AmbOrderFastEntity.OrderFastTypeWaitReceive, scanTime);
	}

	@Override
	public int createOrderFastReceived(Long mainOrderId, Long consumerId,Long subOrderId,Long appId) {
		Date scanTime = DateUtil.daysAddOrSub(new Date(), AmbOrderFastEntity.ScanTime7Day);
		return innerCreateOrderFast(mainOrderId, consumerId, subOrderId,appId,AmbOrderFastEntity.OrderFastTypeReceived, scanTime);
	}

	@Override
	public int createOrderFastWaitPostsale(Long mainOrderId, Long consumerId,Long subOrderId,Long appId) {
		Date scanTime = DateUtil.daysAddOrSub(new Date(), AmbOrderFastEntity.ScanTime7Day);
		return innerCreateOrderFast(mainOrderId, consumerId,subOrderId,appId, AmbOrderFastEntity.OrderFastTypeWaitPostsale, scanTime);
	}

	@Override
	public int createOrderFastAfterAgree(Long mainOrderId, Long consumerId,Long subOrderId,Long appId) {
		Date scanTime = DateUtil.daysAddOrSub(new Date(), AmbOrderFastEntity.ScanTime14Day);
		return innerCreateOrderFast(mainOrderId, consumerId,subOrderId,appId, AmbOrderFastEntity.OrderFastTypeAfterAgree, scanTime);
	}

	@Override
	public int createOrderFastMaxTime(Long mainOrderId, Long consumerId,Long subOrderId,Long appId) {
		Date scanTime = DateUtil.daysAddOrSub(new Date(), AmbOrderFastEntity.ScanTime60Day);
		return innerCreateOrderFast(mainOrderId, consumerId, subOrderId,appId,AmbOrderFastEntity.OrderFastTypeMaxTime, scanTime);
	}

	@Override
	public int removeOrderFastWaitPay(Long orderId) {
		return ambOrderFastDAO.deleteByTypeAndOrderId(orderId, AmbOrderFastEntity.OrderFastTypeWaitPay);
	}

	@Override
	public int removeOrderFastWaitReceive(Long orderId) {
		return ambOrderFastDAO.deleteByTypeAndOrderId(orderId, AmbOrderFastEntity.OrderFastTypeWaitReceive);
	}

	@Override
	public int removeOrderFastReceived(Long orderId) {
		return ambOrderFastDAO.deleteByTypeAndOrderId(orderId, AmbOrderFastEntity.OrderFastTypeReceived);
	}

	@Override
	public int removeOrderFastWaitPostsale(Long orderId) {
		return ambOrderFastDAO.deleteByTypeAndOrderId(orderId, AmbOrderFastEntity.OrderFastTypeWaitPostsale);
	}

	@Override
	public int removeOrderFastAfterAgree(Long orderId) {
		return ambOrderFastDAO.deleteByTypeAndOrderId(orderId, AmbOrderFastEntity.OrderFastTypeAfterAgree);
	}

	@Override
	public int removeOrderFastMaxTime(Long orderId) {
		return ambOrderFastDAO.deleteByTypeAndOrderId(orderId, AmbOrderFastEntity.OrderFastTypeMaxTime);
	}

	@Override
	public int removeOrderFastAtFinish(Long orderId) {
		return ambOrderFastDAO.deleteByOrderId(orderId);
	}

	private int innerCreateOrderFast(Long mainOrderId, Long consumerId,Long subOrderId,Long appId, String orderFastType, Date scanTime) {
		AmbOrderFastEntity fast = new AmbOrderFastEntity();
		fast.setConsumerId(consumerId);
		fast.setOrderId(mainOrderId);
		fast.setAppId(appId);
		fast.setAmbSubOrderId(subOrderId);
		fast.setOrderFastType(orderFastType);
		fast.setScanTime(scanTime);
		return ambOrderFastDAO.insert(fast);
	}

	@Override
	public AmbOrderFastEntity lock(Long id) {
		return ambOrderFastDAO.findForUpdate(id);
	}

	@Override
	public AmbOrderFastEntity findByOrderIdAndType(Long orderId, String type) {
		return ambOrderFastDAO.findByOrderIdAndType(orderId, type);
	}

}
