package cn.com.duiba.goods.center.biz.service.amb.impl;

import cn.com.duiba.goods.center.biz.dao.amb.AmbAlipayPaybackDAO;
import cn.com.duiba.goods.center.biz.dao.amb.AmbPaychannelOrdersDAO;
import cn.com.duiba.goods.center.biz.dao.amb.AmbSubOrdersDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbAlipayPaybackEntity;
import cn.com.duiba.goods.center.biz.entity.amb.AmbPaychannelOrdersEntity;
import cn.com.duiba.goods.center.biz.entity.amb.AmbSubOrdersEntity;
import cn.com.duiba.goods.center.biz.service.amb.AmbOrderFastService;
import cn.com.duiba.goods.center.biz.service.amb.AmbPaybackService;
import cn.com.duiba.paycenter.client.AmbPayCenterServiceClient;
import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.result.AmbResult;
import cn.com.duiba.paycenter.service.AmbPayCenterService.AmbPayParams;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import com.google.common.util.concurrent.Uninterruptibles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import java.util.concurrent.TimeUnit;

/**
 * 
 退款逻辑处理类 负责退款时的业务处理
 *
 */
@Service
public class AmbPaybackServiceImpl implements AmbPaybackService
{
	private static Logger log= LoggerFactory.getLogger(AmbPaybackServiceImpl.class);

	@Autowired
	private AmbAlipayPaybackDAO ambAlipayPaybackDAO;

	@Autowired
	private AmbSubOrdersDAO ambSubOrdersDAO;

	@Autowired
	private AmbOrderFastService ambOrderFastService;

	@Autowired
	private AmbPaychannelOrdersDAO ambPaychannelOrdersDAO;

	@Autowired
	private AmbPayCenterServiceClient ambPayCenterServiceClient;
	
	@Autowired
	private PlatformTransactionManager transactionManager;

	/**
	 * 主定单业务逻辑 失败的时候，makeFail的时候，进行以下操作
	 * 
	 * @param orders
	 * @return
	 */
	public void createPayBackRecordAtMakeFail(OrdersDO orders)throws Exception
	{
		DefaultTransactionDefinition def = new DefaultTransactionDefinition();
		TransactionStatus status = transactionManager.getTransaction(def);

		AmbSubOrdersEntity sub = this.ambSubOrdersDAO.findSubOrderById(orders.getSubOrderId());
		try
		{
			/*** 修改字定单结算状态为 none ***/
			ambSubOrdersDAO.updateSettleStatusNoneBySubId(orders.getSubOrderId(), orders.getConsumerPayPrice());
			/** 加钱购 定单失败 ，删除加速表中数据 **/
			ambOrderFastService.removeOrderFastAtFinish(orders.getId());

		} catch (Exception e)
		{
			status.setRollbackOnly();
			log.error("createPayBackRecordAtMakeFail:" + e);
			throw e;
		} finally
		{
			transactionManager.commit(status);
		}
		/** 修改对应支付通道中退款记录 数据 **/
		if(null==sub.getAmbPaychannelOrdersId()){
			//支付通道不存在  说明 没有付过款  流程结束
			return ;
		}
		AmbPaychannelOrdersEntity channel = ambPaychannelOrdersDAO.findById(sub.getAmbPaychannelOrdersId());
		if(null!=channel &&  AmbPaychannelOrdersEntity.PayChannelOrdersStatusSuccess.equals(channel.getStatus())){
			ambPaychannelOrdersDAO.updatePayBackMoneyByIdAndStatusSuccess(channel.getId(), orders.getConsumerPayPrice());
		}else{
			//支付通道不存在  说明 没有付过款  流程结束
			return ;
		}
		if (AmbPaychannelOrdersEntity.PayChannelOrdersPayChannelTypeAlipay.equals(channel.getPaychannelType()))
		{
			AmbPaychannelOrdersEntity channelOrder=ambPaychannelOrdersDAO.findById(sub.getAmbPaychannelOrdersId());
			
			AmbAlipayPaybackEntity payback = new AmbAlipayPaybackEntity();
			payback.setAmbPaychannelOrderId(sub.getAmbPaychannelOrdersId());
			payback.setAmbSubOrderId(sub.getId());
			payback.setOrderId(orders.getId());
			payback.setTradeNo(channelOrder.getTradeNum());

			payback.setRefundPrice(orders.getConsumerPayPrice());
			if (OrdersDO.AuditStatusReject.equals(orders.getAuditStatus()))
			{
				payback.setReason("审核拒绝");

			} else
			{
				payback.setReason("发货取消");
			}
			payback.setOrderNum(orders.getOrderNum());
			payback.setStatus(AmbAlipayPaybackEntity.AlipayPaybackStatusWait);

			ambAlipayPaybackDAO.createAlipayPayBackRecord(payback);
		} else
		{
			// 其它方式的退款方式
			log.error("");
			throw new Exception("支付类型有误");
		}
		/**** 向支付中心中 走退款 **/
		try
		{
			payCenterComsumerPayBack(orders, sub);
		} catch (Exception e)
		{
			log.error("向支付中心  发起退款失败",e);
		}
	}

	/**
	 * 
	 用户付款成功之后，去判断定单加速表中有没有wait_pay状态的记录，如果不存在就表示已经付过款，直接还款
	 */
	public void createPayBackRecordAtPaySuccess(OrdersDO orders)throws Exception
	{
		AmbSubOrdersEntity sub = this.ambSubOrdersDAO.findSubOrderById(orders.getSubOrderId());
		AmbPaychannelOrdersEntity channel = ambPaychannelOrdersDAO.findById(sub.getAmbPaychannelOrdersId());

		/****向支付中心中 走退款**/
		if (AmbPaychannelOrdersEntity.PayChannelOrdersPayChannelTypeAlipay.equals(channel.getPaychannelType()))
		{
			AmbAlipayPaybackEntity payback = new AmbAlipayPaybackEntity();
			payback.setAmbPaychannelOrderId(sub.getAmbPaychannelOrdersId());
			payback.setAmbSubOrderId(sub.getId());
			payback.setOrderId(orders.getId());

			payback.setTradeNo(channel.getTradeNum());
			payback.setRefundPrice(orders.getConsumerPayPrice());
			payback.setReason("加速表中不存在wait_pay状态的定单记录，直接还款，可能是30分钟支付超时！ ");
			payback.setOrderNum(orders.getOrderNum());
			payback.setStatus(AmbAlipayPaybackEntity.AlipayPaybackStatusWait);

			 ambAlipayPaybackDAO.createAlipayPayBackRecord(payback);
		} else
		{
			throw new Exception("支付类型不正确");
			// 其它方式的退款方式
		}
		try
		{
			payCenterComsumerPayBack(orders,sub);
		} catch (Exception e)
		{
			log.error("支付中心退款异常",e);
		}
	}

	private void payCenterComsumerPayBack(OrdersDO order, AmbSubOrdersEntity sub)throws Exception
	{

		AmbPayParams payParams = new AmbPayParams();
		payParams.setConusmerId(order.getConsumerId());
		payParams.setAppId(order.getAppId());
		payParams.setOrdersSource(sub.getOrdersSource());

		Long developerId = order.getDeveloperId();
		Long orderId = order.getId();
		Long consumerPrice = order.getConsumerPayPrice();
		RpcResult<AmbResult> result = ambPayCenterServiceClient.consumerPayBack(developerId, orderId, consumerPrice, payParams);
		if (!result.isOpSuccess())
		{
			if(log.isInfoEnabled()) {
				log.info("ambPayCenterServiceClient.consumerPayBack exception developer_id " + developerId + " orderId " + orderId + " consumerPrice " + consumerPrice, result.getRpcException());
			}// 启动重试机制
			for (int i = 0; i < OrdersDO.try_again_count; i++)
			{
				Uninterruptibles.sleepUninterruptibly(OrdersDO.try_again_interval_time, TimeUnit.MILLISECONDS);
				result = ambPayCenterServiceClient.consumerPayBack(developerId, orderId, consumerPrice, payParams);
				if (result.isOpSuccess())
				{
					// 操作成功
					break;
				}
				// 第i次重试失败
				if(log.isInfoEnabled()) {
					log.info("call ambPayCenterServiceClient.consumerPayBack exception developId: " + developerId + " try again " + i + ",orderId " + orderId);
				}
			}

			if (!result.isOpSuccess())
			{
				if(log.isInfoEnabled()) {
					log.info("call ambPayCenterServiceClient.consumerPayBack exception   developId: " + developerId + ",orderId " + orderId, result.getRpcException());
				}
				String remark = sub.getRemark();
				remark = "consumerPay用户支付成功后调用支付中心，网络异常！  " + remark;
				this.ambSubOrdersDAO.updateRemarkBySubId(sub.getId(), remark);
				
				throw new Exception("调用支付中心，网络异常");
			}
		}
		if (result.isOpSuccess())
		{
			if (!result.getResult().isBizSuccess())
			{
				if(log.isInfoEnabled()) {
					log.info("ambPayCenterServiceClient.consumerPayBack is finall failed  developId: " + developerId + ",orderId " + orderId, result.getResult().getErrorException());
				}
				String remark = sub.getRemark();
				remark = "consumerPay用户支付成功后调用支付中心，支付中心反馈失败！  " + remark;
				this.ambSubOrdersDAO.updateRemarkBySubId(sub.getId(), remark);
				
				throw new Exception("调用 支付中心，反馈失败");
			}
		}

	}
}
