package cn.com.duiba.goods.center.biz.service.amb.impl;

import cn.com.duiba.goods.center.biz.dao.amb.AmbPaychannelOrdersDAO;
import cn.com.duiba.goods.center.biz.dao.amb.AmbSubOrdersDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbPaychannelOrdersEntity;
import cn.com.duiba.goods.center.biz.entity.amb.AmbSubOrdersEntity;
import cn.com.duiba.goods.center.biz.service.amb.AmbPaychannelOrdersService;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/**
 * 
 * 处理支付通道
 *
 */
@Service
public class AmbPaychannelOrdersServiceImpl implements
		AmbPaychannelOrdersService
{

	@Autowired
	private AmbPaychannelOrdersDAO ambPayChannelOrdersDao;

	@Autowired
	private AmbSubOrdersDAO ambSubOrdersDao;

	@Autowired
	private PlatformTransactionManager transactionManager;

	@Override
	public int createAmbPayChannelOrder(OrdersDO order, String type) throws Exception
	{
		TransactionDefinition def = new DefaultTransactionDefinition();
		TransactionStatus status = transactionManager.getTransaction(def);
		try
		{
			if(!OrdersDO.ConsumerPayStatusWaitPay.equals(order.getConsumerPayStatus())){
				throw new Exception("定单不是待付款状态");
			}
			if(!OrdersDO.StatusConsumeSuccess.equals(order.getStatus())){
				throw new Exception("扣积分成功才能付款");
			}
			AmbSubOrdersEntity sub = this.ambSubOrdersDao.findSubOrderById(order.getSubOrderId());

			AmbPaychannelOrdersEntity pay = new AmbPaychannelOrdersEntity();
			pay.setAmbSubOrdersId(sub.getId());
			pay.setAppId(order.getAppId());
			pay.setConsumerMoney(order.getConsumerPayPrice());

			pay.setDeveloperId(order.getDeveloperId());
			pay.setOrderNum(order.getOrderNum());
			pay.setOrdersId(order.getId());

			pay.setOrdersSource(sub.getOrdersSource());

			pay.setPaychannelType(type);
			pay.setStatus(AmbPaychannelOrdersEntity.PayChannelOrdersStatusWaitPay);

			int ret = ambPayChannelOrdersDao.createAmbPayChannelOrder(pay);
			if (ret == 0)
			{
				throw new Exception("生成支付通道定单异常");
			}

			ret = ambSubOrdersDao.updatePayChannelIdBySubId(pay.getId(), sub.getId());
			if (ret == 0)
			{
				throw new Exception("更新子定单相关支付通道信息异常");
			}
			return ret;
		} catch (Exception e)
		{
			status.setRollbackOnly();
			throw e;
		} finally
		{
			transactionManager.commit(status);
		}
	}
}
