package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.cache.IPCache;
import cn.com.duiba.goods.center.biz.dao.AddrLimitDao;
import cn.com.duiba.goods.center.biz.dao.item.IpLibraryDao;
import cn.com.duiba.goods.center.biz.entity.IpLibraryEntity;
import cn.com.duiba.goods.center.biz.service.AddrLimitService;
import cn.com.duiba.goods.center.common.MemcachedKeyFactory;
import cn.com.duiba.wolf.cache.CacheClient;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by wenqi.huang on 16/5/25.
 */
@Service
public class AddrLimitServiceImpl implements AddrLimitService {
	@Resource
	private AddrLimitDao addrLimitDao;
	@Autowired
	private IpLibraryDao ipLibraryDao;
	@Autowired
	private CacheClient cacheClient;

	@Override
	public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId) {
		return addrLimitDao.findAddrLimitByAppItemId(appItemId);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByItemId(Long itemId) {
		return addrLimitDao.findAddrLimitByItemId(itemId);
	}

	@Override
	public Integer findTypeByAppItemId(Long appItemId) {
		return addrLimitDao.findTypeByAppItemId(appItemId);
	}

	@Override
	public Integer findTypeByItemId(Long itemId) {
		return addrLimitDao.findTypeByItemId(itemId);
	}

	@Override
	public void batchInsertAddrLimit(List<AddrLimitDto> addrLimitList) {
		addrLimitDao.batchInsertAddrLimit(addrLimitList);
	}

	@Override
	public void deleteAddrLimit(Long itemId, Long appItemId) {
		addrLimitDao.deleteAddrLimit(itemId, appItemId);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds) {
		return addrLimitDao.findAddrLimitByAppItemIds(appItemIds);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds) {
		return addrLimitDao.findAddrLimitByItemIds(itemIds);
	}

	@Override
	public IPCache findCodeByIpLong(Long ipLong) {
		String key = MemcachedKeyFactory.K001 + String.valueOf(ipLong);
		String value = cacheClient.get(key);
		if (value == null) {
			IpLibraryEntity entity = ipLibraryDao.findCodeByIpLong(ipLong);
			if (entity == null) {
				// 数据库为NULL,往缓存方一个NULL穿避免null命中数据库
				cacheClient.set(key, "NULL", 120, TimeUnit.SECONDS);
				return null;
			}
			IPCache cache = new IPCache();
			cache.setCode(entity.getCode());
			cache.setEndIpNum(entity.getEndIpNum());
			cacheClient.set(key, JSONObject.toJSONString(cache), 120, TimeUnit.SECONDS);
			return cache;
		}
		if ("NULL".equals(value)) {
			return null;
		}
		return JSONObject.parseObject(value, IPCache.class);
	}
}
