/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerGoodsServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年5月26日下午7:04:22
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerGoodsDto;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;

/**
 * ClassName:PCGSellerGoodsServiceImpl <br/>
 * Date:     2016年5月26日 下午7:04:22 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("pCGSellerGoodsService")
public class PCGSellerGoodsServiceImpl implements PCGSellerGoodsService{
    @Autowired
    private PCGSellerGoodsDao pcgSellerGoodsDao;
    @Autowired
    private PCGSellerDao pcgSellerDao;
    @Autowired
	private RedisTemplate<String, String> redisTemplate;
    @Override
    public Boolean addGoods2Seller(long sellerId, long pcgId,Integer payload) {
    	if(payload==null || payload==0 ){
    		payload =pcgSellerGoodsDao.selectMaxPayloadBySellerId(sellerId);
    		payload = payload+1;
    	}
        int ret=pcgSellerGoodsDao.insertGoods2Seller(pcgId, sellerId,payload);
        return ret == 1 ? true : false;
    }

    @Override
    public Boolean removeGoodsFromSeller(long sellerId, long pcgId) {
    	RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
    	/**清除当前品牌商品列表缓存*/
    	redisFilterCache.clearFilterCache(redisFilterCache.getSellerGoodsRedisKey(String.valueOf(sellerId)));
        int ret=pcgSellerGoodsDao.deleteGoods2Seller(pcgId, sellerId);
        return ret == 1 ? true : false;
    }
    
    @Override
    @Transactional("pcg")
    public Boolean removeSeller(long sellerId) {
    	RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
    	/**清除当前品牌商品列表缓存*/
    	redisFilterCache.clearFilterCache(redisFilterCache.getSellerGoodsRedisKey(String.valueOf(sellerId)));
    	/**清除品牌列表缓存*/
    	redisFilterCache.clearFilterCache(redisFilterCache.getSellerRedisKey());
        pcgSellerDao.delete(sellerId);
        pcgSellerGoodsDao.deleteSellerRelation(sellerId);
        return true;
    }


    @Override
    public Boolean deleteAllByPcgId(long pcgId) {
    	RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
    	List<PCGSellerGoodsEntity> pcgs =pcgSellerGoodsDao.selectByGoods(pcgId);
    	for(PCGSellerGoodsEntity p :pcgs){
    		/**清除查询品牌商品列表缓存*/
    		redisFilterCache.clearFilterCache(redisFilterCache.getCategoryGoodsRedisKey(String.valueOf(p.getSellerId())));
    	}
        pcgSellerGoodsDao.deleteGoodsRelation(pcgId);
        return true;
    }
    
    @Override
    public Long addSeller(String name,String logo,Integer payload) {
    	if(payload==null || payload==0 ){
    		payload =pcgSellerDao.selectMaxPayloadBySeller();
    		payload = payload+1;
    	}
        return pcgSellerDao.insert(name,logo,payload);
    }

    @Override
    public List<PCGSellerEntity> findAll() {
    	RedisFilterCache redisFilterCache=new RedisFilterCache(redisTemplate);
    	List<PCGSellerEntity> sellers = redisFilterCache.getFilterListCache(redisFilterCache.getSellerRedisKey(),PCGSellerEntity.class);
    	if(sellers ==null || sellers.isEmpty()){
    		sellers = pcgSellerDao.selectAll();
    	}
        return sellers;
    }
    @Override
    public List<PCGSellerGoodsEntity> findAllGoodsBySeller(long sellerId) {
        return pcgSellerGoodsDao.selectBySeller(sellerId);
    }
    @Override
    public PCGSellerEntity findSeller(Long id) {
        return pcgSellerDao.select(id);
    }
    
    @Override
    public void sortSellerGoods(List<PCGSellerGoodsDto> list) {
        for(PCGSellerGoodsDto dto:list){
            pcgSellerGoodsDao.updatePayload(dto.getSellerId(), dto.getPcgId(), dto.getPayload());
        }
    }
    
    @Override
    public void sortSellers(List<PCGSellerDto> sellers) {
        for(PCGSellerDto dto:sellers){
            pcgSellerDao.updatePayload(dto.getId(), dto.getPayload());
        }
    }
    
    @Override
    public void updateSellerPayload(Long id, int payload) {
        pcgSellerDao.updatePayload(id, payload);
    }
    
    @Override
    public void updateNamePayloadAndLogo(Long id,String name,String logo,Integer payload) {
        pcgSellerDao.updateNamePayloadAndLogo(id,name,logo,payload);
    }

	@Override
	public List<PCGSellerGoodsEntity> findAllGoodsBySellerIds(
			List<Long> sellerIds) {
		return pcgSellerDao.selectAllGoodsBySellerIds(sellerIds);
	}
}

