package cn.com.duiba.goods.center.biz.service.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;

/**
 * EverydayLimitService
 */
public interface EverydayLimitService {
	
	/**
	 * 是否是每日限量商品
	 * @param itemKeyDto
	 * @return
	 */
	public Boolean isEverydayLimit(ItemKeyDto itemKeyDto);
	
	/**
	 * 查询每日限量库存
	 * @param itemKeyDto
	 * @return
	 */
	public Long findEverydayStock(ItemKeyDto itemKeyDto);
	
	/**
	 * 扣除每日限量库存
	 * @param itemKeyDto
	 * @return
	 */
	public Boolean decrEeverydayStock(ItemKeyDto itemKeyDto);
	
	/**
	 * 返还每日限量库存
	 * @param itemKeyDto
	 * @return
	 */
	public Boolean incrEverydayStock(ItemKeyDto itemKeyDto);
	
	
	/**
	 * 查询每日限量的销售数量
	 * @param appItemId
	 * @param itemId
	 * @return
	 */
	public Integer findEverydayLimitSales(Long appItemId, Long itemId);
	/**
	 * findEverydayLimitSales
	 * @param itemKeyDto
	 * @return
	 */
	public Integer findEverydayLimitSales(ItemKeyDto itemKeyDto);
	
	/**
	 * 每日限量
	 * @param appItemId
	 * @param itemId
	 * @param limit
	 * @return
	 */
	public boolean updateEverydaySales(Long appItemId, Long itemId, int limit);
	
	/**
	 * 返还每日限量
	 * @param appItemId
	 * @param itemId
	 */
	public void rollbackEverydayLimit(Long appItemId, Long itemId);

}
