package cn.com.duiba.goods.center.biz.service.item.impl;

import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.enums.ItemMarkEnum;
import cn.com.duiba.goods.center.biz.service.item.MobileShowItemService;

/**
 * 
 * MobileShowItemServiceImpl
 *
 */
@Service("mobileShowItemService")
public class MobileShowItemServiceImpl implements MobileShowItemService {

    @Override
    public ItemMarkEnum getMarkType(ItemKeyDto itemKey) {
        if (itemKey.isDuibaAppItemMode()) {
            // 秒杀（限时）
            if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit) || itemKey.getItem().isOpTypeItem(ItemDto.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            } else if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeAddrLimit) || itemKey.getItem().isOpTypeItem(ItemDto.OpTypeAddrLimit)) {

                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isItemMode()) {
            // 秒杀（限时）
            if (itemKey.getItem().isOpTypeItem(ItemDto.OpTypeTimeLimit)) {
                return ItemMarkEnum.MARK_TIME;
                // 地域限制
            }else if (itemKey.getItem().isOpTypeItem(ItemDto.OpTypeAddrLimit)) {
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeAddrLimit)) {
                //地域限制
                return ItemMarkEnum.MARK_ADDRLIMIT;
            }else if (itemKey.getAppItem().isOpTypeAppItem(ItemDto.OpTypeTimeLimit)) {
                // 秒杀（限时）
                return ItemMarkEnum.MARK_TIME;
            }else if (itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeSingleLottery
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeOperatingActivity
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeManualLottery
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeAppShakeLottery
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTiger
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeHdtoolTurntable
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameSanta
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameYearAward
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameGirl
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGameJiong
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuestionAnswer
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeDuibaQuizz
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeNgame
                      || itemKey.getAppItem().getSourceType() == AppItemDto.SourceTypeGuess) {
                // 抽奖
                return ItemMarkEnum.MARK_LOTTERY;
            }
        }
        return ItemMarkEnum.MARK_NORMAL;
    }
    
}
