package cn.com.duiba.goods.center.biz.service.stock.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemAppSpecifyDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;
import cn.com.duiba.goods.center.biz.service.stock.ItemAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * Created by liuyao on 2017/1/11.
 */
@Service
public class ItemAppSpecifyServiceImpl implements ItemAppSpecifyService {
    @Autowired
    private ItemAppSpecifyDao itemAppSpecifyDao;

    @Override
    public List<ItemAppSpecifyDto> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        if(itemIds.isEmpty()){
            return Collections.emptyList();
        }
        List<ItemAppSpecifyEntity> list = itemAppSpecifyDao.findSpecifyByItemIdsAndAppId(itemIds,appId);

        return BeanUtils.copyList(list,ItemAppSpecifyDto.class);
    }
}
