package cn.com.duiba.goods.center.biz.service.stock.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.service.stock.MemStockService;
import cn.com.duiba.wolf.cache.CacheClient;

/**
 * 
 * MemStockServiceImpl
 *
 */
@Service
public class MemStockServiceImpl implements MemStockService {

	private static final Logger LOGGER = LoggerFactory.getLogger(MemStockServiceImpl.class);
	
	private static final String STOCK_LOCK_KEY = "redislockstock-";

    @Resource
    private CacheClient memcachedClient;

    @Override
	public boolean getLock(String key) {
		try {
			for (int i = 0; i < 10; i++) {
				boolean ret = memcachedClient.add(STOCK_LOCK_KEY + key, 10, "locked");
	            if (ret) {
					return true;
				}
				TimeUnit.MILLISECONDS.sleep(15);
			}
		} catch (Exception e) {
			LOGGER.error("getLock", e);
		}
		return false;
	}
	
    @Override
	public boolean getLock(String key, int timeout) {
		try {
			for (int i = 0; i < 10; i++) {
				boolean ret = memcachedClient.add(STOCK_LOCK_KEY + key, timeout, "locked");
				if (ret) {
					return true;
				}
				TimeUnit.MILLISECONDS.sleep(15);
			}
		} catch (Exception e) {
			LOGGER.error("getLock", e);
		}
		return false;
	}

    @Override
	public void unlock(String key) {
		try {
			memcachedClient.remove(STOCK_LOCK_KEY + key);
		} catch (Exception e) {
			LOGGER.error("unlock",e);
		}
	}

	@Override
	public boolean consumeEverydayStock(String key, Integer limitStock) {
		boolean tryLock = false;
		try {
			tryLock = getLock(key);
			if (tryLock) {
				String stocKey = "everydayStock" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + key;
				Object value = memcachedClient.get(stocKey);
				if(value!=null){
					if (Integer.valueOf(value.toString()) >= limitStock) {
						return false;
					}
				}
				memcachedClient.incr(stocKey, 1, 0, 86400, TimeUnit.SECONDS);
				return true;
			}
		} catch (Exception e) {
			LOGGER.error("everydayStock", e);
		} finally {
			if(tryLock){
				unlock(key);
			}
		}
		return false;
	}


}
