package cn.com.duiba.goods.center.biz.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

import org.slf4j.Logger;

import org.slf4j.LoggerFactory;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;

/**
 * 定义缓存的key,为了防止和其他项目中的key重复,在每个值前面加上子模块名前缀 Created by wenqi.huang on 16/4/25.
 */
public class CacheConstants {

	private static final Logger LOG = LoggerFactory.getLogger(AppendUploadUtil.class);

	public static final String KEY_BANNER_ICON_APP_ITEM = "item.bannerIconAppItem_";
	public static final String KEY_HOME_ITEM_KEY = "item.homeItemKey_";
	public static final String KEY_APP_ITEM_BY_ID = "item.appItemId_";
	public static final String KEY_ITEM_BY_ID = "item.itemId_";
	public static final String KEY_ITEM_APP_SPECIFY_BY_ITEMID_APPID = "item.itemAppSpecify_itemId_appId_";
	public static final String KEY_APP_ITEM_EXTRA_BY_APPITEMID = "item.appItemExtraByAppItemId_";
	public static final String KEY_COUPON_BATCH_BY_ID = "item.couponBatchById_";
	public static final String KEY_APP_ITEM_CLASSIFY_BY_ID = "item.appItemClassifyById_";
	public static final String KeyItemIdCacheOfAppItemMaskByAppId = "item.itemIdCacheOfAppItemMaskByAppId_";
	public static final String KEY_ITEM_EXTRA_BY_ITEM_ID = "item.itemExtraByItemId_";
	public static final String KEY_SELLER_BY_ID = "item.sellerId_";
	public static final String KEY_DUIBA_TURNTABLE_BY_ID = "item-duibaTurntableById_";
	/**
	 * Banner,Icon,Item 上下架通知
	 */
	public static final int MS_STATUS_MODIFY_NOTIFY = 105;

	/**
	 * 预分配库存
	 */
	public static final int MS_PRE_STOCK_QUANTITY = 121;

	// 不允许存在相同的静态常量,这里做判断,如果有相同的就抛出异常
	static {
		Field[] fields = CacheConstants.class.getFields();
		Set<String> set = new HashSet<>();
		for (Field f : fields) {
			try {
				boolean success = set.add(f.get(null) + "_" + f.getType().getName());
				if (!success) {
					throw new RuntimeGoodsException(ErrorCode.E9999999);
				}
			} catch (IllegalAccessException e) {
				LOG.error("set.add", e);
			}
		}
	}

}
