package cn.com.duiba.goods.center.biz.bo;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ImmediatelyButtonDto;

/**
 * 马上使用按钮接口
 */
public interface ImmediatelyButtonBackendBo {
	/**
	 * selectImmediatelyButtonFromItem:马上使用按钮跳转链接. <br/>
	 *
	 * @author guoeryang
	 * @param itemId
	 * @param gtype
	 *            0:兑吧商品 1：自有商品 2：券库
	 * @param userAgent
	 *            请求端类型
	 * @param hdtoolFalg
	 *            活动表示 1表示 活动页面 2 兑换详情页
	 * @param urlParameter
	 *            生成曝光链接用 （为空时 ：不生成 埋点url）
	 * @param embedClickurl
	 *            埋点服务器地址（为空时 ：不生成 埋点url）
	 * @return
	 * @since JDK 1.6
	 */
	public String selectImmediatelyButtonFromItem(Long itemId, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String urlParameter, String embedClickurl);

	/**
	 * selectImmediatelyButtonFromCoupon:马上使用按钮跳转链接. <br/>
	 *
	 * @author guoeryang
	 * @param couponId
	 * @param itemId
	 * @param orderId
	 * @param urlParameter
	 *            （已当做用户Id）
	 * @param embedClickurl
	 *            埋点服务器地址（为空时 ：不生成 埋点url）
	 * @return
	 * @since JDK 1.6
	 */
	public String selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl);

	/**
	 * selectImmediatelyForPlatFrom:马上使用按钮跳转链接. <br/>
	 *
	 * @author guoeryang
	 * @param itemId
	 * @param gtype
	 *            0:兑吧商品 1：自有商品 2：券库
	 * @param userAgent
	 *            请求端类型
	 * @param hdtoolFalg
	 *            活动表示 1表示 活动页面 2 兑换详情页
	 * @param urlParameter
	 *            生成曝光链接用 （为空时 ：不生成 埋点url）
	 * @param embedClickurl
	 *            埋点服务器地址（为空时 ：不生成 埋点url）
	 * @return
	 * @since JDK 1.6
	 */
	public ImmediatelyButtonDto selectImmediatelyForPlatfrom(Long gid, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String consunmerId);

}
