package cn.com.duiba.goods.center.biz.bo.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.CreditsCalculateBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * 计算商品积分
 */
@Service
public class CreditsCalculateBoImpl implements CreditsCalculateBo {

	@Autowired
	private PreStockService preStockService;

	/**
	 * 计算消耗积分数 如果是有档次的兑换商品，传入degree，如果没有传入degreee，返回最小档次的积分
	 *
	 * @param key 商品
	 * @param degree 档位
	 * @param appCreditsRate APP的汇率
	 * @return
	 */
	@Override
	public Long calculateCreditsByItemKeyAndDegree(ItemKeyDto key, String degree, Long appRate) {
		if (ItemDO.TypeFake.equals(key.getItemDtoType())) {
			boolean custom = key.getAppItem() != null && key.getAppItem().getCustomPrice() != null && key.getAppItem().getCustomPrice().contains("duiba");
			if (custom) {
				if (key.getAppItem().isOpTypeAppItem(AppItemDO.SwitchExchangeCreditsType)) {
					return key.getAppItem().getCredits();
				}
				return getCreditsRate(key.getAppItem().getCredits(), appRate);
			}
		}
		if (key.isItemMode()) {
			long credits = getCreditsRate((long) key.getItem().getFacePrice(), appRate);
			// 判断是否开启了库存预分配
			if (key.getItem().isOpTypeItem(ItemDO.OpTypePreStockSwith)) {
				ItemEntity itemEntity = BeanUtils.copy(key.getItem(), ItemEntity.class);
				Integer minFacePrice = preStockService.getMinExchangePrice(itemEntity, key.getAppId());
				if (null != minFacePrice) {
					credits = getCreditsRate((long) minFacePrice, appRate);
				}
			}
			// 积分最小值为1
			if (credits < 1L) {
				credits = 1L;
			}
			return credits;
		} else if (key.isDuibaAppItemMode()) {
			if (ItemDO.TypePhoneflow.equals(key.getItem().getType())) {
				// ==============流量特殊的情况==============
				if (degree == null) {
					// 没传档位的返回1块钱做为最低档位计算积分
					return appRate;
				}
				// 有传档位的根据传入价格计算积分
				return Long.valueOf(degree) * appRate;
			} else if (ItemDO.TypeAlipay.equals(key.getItem().getType()) || ItemDO.TypeAlipayCode.equals(key.getItem().getType()) || ItemDO.TypeAlipayFast.equals(key.getItem().getType()) || ItemDO.TypeQB.equals(key.getItem().getType()) || ItemDO.TypePhonebill.equals(key.getItem().getType())) {
				if (degree == null) {
					// 有档位的商品没传degree的情况：返回最小档位的积分
					PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
					if (pd.getMinDegreeCredits() == null) {
						return pd.getMinDegreeInt() * appRate * 1L;
					}
					return Long.valueOf(pd.getMinDegreeCredits());
				}
				// 有传degree的情况，判断档位是否存在，存在则返回档位相应的积分，否则抛异常。
				PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
				if (pd.isDegreeExist(degree)) {
					if (pd.getCreditsByDegree(degree) == null) {
						return Long.valueOf(degree) * appRate;
					}
					return Long.valueOf(pd.getCreditsByDegree(degree));
				}
				throw new RuntimeGoodsException(ErrorCode.E0404013);
			} else if (ItemDO.TypeCoupon.equals(key.getItem().getType()) || ItemDO.TypeObject.equals(key.getItem().getType()) || ItemDO.TypePhonebillDingzhi.equals(key.getItem().getType())) {
				Long credits;
				if (key.getAppItem().getCredits() != null) {
					credits = key.getAppItem().getCredits();
				} else {
					// 根据面额和汇率计算积分（小数进位）
					credits = getCreditsRate((long) key.getItem().getFacePrice(), appRate);
					// 判断是否开启了库存预分配
					if (key.getItem().isOpTypeItem(ItemDO.OpTypePreStockSwith)) {
						ItemEntity itemEntity = BeanUtils.copy(key.getItem(), ItemEntity.class);
						Integer minFacePrice = preStockService.getMinExchangePrice(itemEntity, key.getAppId());
						if (null != minFacePrice) {
							credits = getCreditsRate((long) minFacePrice, appRate);
						}
					}
				}
				// 积分最小值为1
				if (credits < 1L) {
					credits = 1L;
				}
				return credits;
			}
			throw new RuntimeGoodsException(ErrorCode.E0404013);
		} else if (key.isSelfAppItemMode()) {
			if (ItemDO.TypeVirtual.equals(key.getAppItem().getType())) {
				PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
				if (degree == null) {
					return pd.getMinDegreeCredits() == null ? null : Long.valueOf(pd.getMinDegreeCredits());
				}
				// 有传degree的情况，判断档位是否存在，存在则返回档位相应的积分，否则抛异常。
				if (pd.isDegreeExist(degree)) {
					return Long.valueOf(pd.getCreditsByDegree(degree));
				}
				throw new RuntimeGoodsException(ErrorCode.E0404013);
			}
			return key.getAppItem().getCredits();
		}
		throw new RuntimeGoodsException(ErrorCode.E0404013);
	}

	private Long getCreditsRate(Long price, Long appRate) {
		return (long) Math.ceil(price * appRate / 100.0);
	}

}
