package cn.com.duiba.goods.center.biz.bo.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ImmediatelyButtonDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.ImmediatelyButtonBackendBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.SellerSevice;
import cn.com.duiba.goods.center.biz.service.TbGoodsOpenurlService;
import cn.com.duiba.goods.center.biz.service.item.ItemCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.com.duiba.wolf.utils.UrlUtils;

@Service
public class ImmediatelyButtonBackendBoImpl implements ImmediatelyButtonBackendBo {

	private static final Logger log = LoggerFactory.getLogger(ImmediatelyButtonBackendBoImpl.class);

	@Autowired
	private ItemService itemService;
	@Autowired
	private SellerSevice sellerSevice;
	@Autowired
	private ItemCouponGoodsService itemCouponGoodsService;
	@Resource
	private TbGoodsOpenurlService tbGoodsOpenurlService;
	@Autowired
	private RemoteGoodsCouponService remoteGoodsCouponService;

	/** 美团定制需求 */
	private static final String MEITUAN_URL = "http://i.meituan.com/firework/";
	private static final String MEITUAN_FROM = "duiba";
	private static final String MEITUAN_SALT = "d442c590d699";
	private static final String MEITUAN_END = "&utm_source=waputm_dbjfhd&utm_medium=wap";

	@Override
	public String selectImmediatelyButtonFromItem(Long itemId, GoodsTypeEnum gtype, Long orderId, String ua, String hdtoolFalg, String urlParameter, String embedClickurl) {
		String userAgent = ua.toLowerCase();
		String returls = "";
		TbGoodsOpenUrlDto goodOpenUrl = tbGoodsOpenurlService.findTbGoodsOpenurl(itemId, gtype.getGtype());
		// 新数据
		if (goodOpenUrl != null) {
			// 判断 跳转到那个页面
			if ("2".equals(hdtoolFalg) || goodOpenUrl.getImmediatelyButton() == 1) {
				if (!"2".equals(hdtoolFalg)) {
					returls = "/crecord/recordDetailNew/" + orderId + "?after=1&dbnewopen";
				} else {
					if (userAgent.contains("android")) {
						returls = goodOpenUrl.getAndroidDownload();
					} else {
						returls = goodOpenUrl.getIosDownload();
					}
				}
				// 判断前台页面 请求类型
			} else if (userAgent.contains("android")) {
				returls = goodOpenUrl.getAndroidDownload();
			} else {
				returls = goodOpenUrl.getIosDownload();
			}
			// 旧数据
		} else {
			// 兑吧优惠券
			if (gtype.getGtype() == 0) {
				ItemEntity item = itemService.find(itemId);
				// 入参 校验
				if (item == null) {
					throw new RuntimeGoodsException(ErrorCode.E0404004);
				}
				// 判断前台页面 请求类型
				if (userAgent.contains("android")) {
					returls = item.getAndroidDownload();
				} else {
					if (item.getIosDownload() != null) {
						returls = item.getIosDownload();
					} else {
						returls = item.getIosOpen();
					}
				}
			}
		}

		// 返回详情页
		if (returls == null || returls.length() == 0) {
			returls = "";
			// 露出马上使用按钮
		} else {
			// 数据埋点 urlParameter与 embedClickurl 数据埋点用的 参数 为空时 不需要 埋点
			if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0 &&
			// 当hdtoolFalg=1 与ImmediatelyButton =1 调转到 兑换详情页 不需要做 数据埋点
					!("1".equals(hdtoolFalg) && goodOpenUrl.getImmediatelyButton() == 1)) {
				try {
					returls = embedClickurl + URLEncoder.encode(returls, "utf-8") + urlParameter;
				} catch (UnsupportedEncodingException e) {
					log.error("URLEncoder.encode:", e);
				}
			}
		}
		return returls;
	}

	@Override
	public String selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl) {
		String returls = "";
		ItemEntity item = itemService.find(itemId);
		if (item == null) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		ItemKeyDto itemKeyDto = new ItemKeyDto(null, BeanUtils.copy(item, ItemDto.class));
		GoodsCouponDto coupon = itemCouponGoodsService.findCoupon(itemKeyDto, couponId);
		if (coupon == null) {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}
		if (ItemDto.SubTypeLink == item.getSubType()) {
			returls = coupon.getLink();
		} else {
			returls = coupon.getCode();
		}
		// 0：非安全链接，不需要加密
		if (item.getSellerId() != null && item.getSellerId() != 0) {
			// url参数键值对
			StringBuffer sb = new StringBuffer();
			StringBuffer urlParam = new StringBuffer();
			Map<String, String> mapRequest = null;
			if (!"".equals(returls)) {
				mapRequest = UrlUtils.uRLRequest(returls);
				// 循环商家URL自带的参数
				for (String strRequestKey : mapRequest.keySet()) {
					sb.append(mapRequest.get(strRequestKey));
					if (urlParam.length() == 0) {
						urlParam.append(strRequestKey + "=" + mapRequest.get(strRequestKey));
					} else {
						urlParam.append("&" + strRequestKey + "=" + mapRequest.get(strRequestKey));
					}
				}
			}

			// 美团特殊加密处理
			if (returls.contains(MEITUAN_URL)) {
				return getMeituanUrl(returls, urlParameter, urlParam.toString());
			}

			if (orderId != null) {
				String timestamp = DateUtils.getMillisecond();
				sb.append(timestamp);
				sb.append(orderId);
				if (urlParam.length() == 0) {
					urlParam.append("timestamp=" + timestamp);
				} else {
					urlParam.append("&timestamp=" + timestamp);
				}
				urlParam.append("&orderId=" + orderId);
			}
			SellerDto result = sellerSevice.findById(item.getSellerId());
			returls = UrlUtils.urlPage(returls) + "?" + urlParam + "&sign=" + SecurityUtils.encode2StringBySHA(sb.toString() + result.getSafeSign());
		}
		if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0) {
			try {
				returls = embedClickurl + URLEncoder.encode(returls, "utf-8") + urlParameter;
			} catch (UnsupportedEncodingException e) {
				log.error("URLEncoder.encode:", e);
			}
		}
		return returls;
	}

	/**
	 * 美团特殊处理
	 * 
	 * @param sellerUrl
	 *            商家请求的链接
	 * @param consunmerId
	 *            用户id
	 * @param urlParam
	 *            商家自带参数
	 * @return
	 */
	private static String getMeituanUrl(String sellerUrl, String consunmerId, String urlParam) {
		String sign = SecurityUtils.encode2StringByMd5(consunmerId + MEITUAN_FROM + MEITUAN_SALT).toLowerCase().substring(0, 32);
		return UrlUtils.urlPage(sellerUrl) + "?code=" + consunmerId + "&sign=" + sign + "&from=" + MEITUAN_FROM + urlParam + MEITUAN_END;
	}

	@Override
	public ImmediatelyButtonDto selectImmediatelyForPlatfrom(Long gid, GoodsTypeEnum gtype, Long orderId, String ua, String hdtoolFalg, String consunmerId) {
		String userAgent = ua.toLowerCase();
		TbGoodsOpenUrlDto goodOpenUrl = tbGoodsOpenurlService.findTbGoodsOpenurl(gid, gtype.getGtype());
		ImmediatelyButtonDto dto = new ImmediatelyButtonDto();
		String returls = "";
		dto.setOpenUrl(false);
		dto.setConfirm(false);
		dto.setShowUse(false);
		// 新数据
		if (goodOpenUrl != null) {
			// 判断 跳转到那个页面
			if ("2".equals(hdtoolFalg) || goodOpenUrl.getImmediatelyButton() == 1) {
				if (!"2".equals(hdtoolFalg)) {
					dto.setShowUse(true);
					dto.setBtnText("查看使用方法");
					returls = "/crecord/recordDetailNew/" + orderId + "?after=1";
				} else {
					if (userAgent.contains("android")) {
						if (goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_DOWNLOAD_ALERT_TYPE) && goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_AND_SELECT_TYPE)) {
							dto.setConfirm(true);
						} else {
							dto.setConfirm(false);
						}
						returls = goodOpenUrl.getAndroidDownload();
						if (returls != null && returls.length() > 0) {
							dto.setShowUse(true);
						}
					} else {
						dto.setConfirm(false);
						if (!goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_IOS_SELECT_TYPE)) {
							dto.setOpenUrl(true);
						}
						returls = goodOpenUrl.getIosDownload();
						if (returls != null && returls.length() > 0) {
							dto.setShowUse(true);
						}
					}
				}
				// 判断前台页面 请求类型
			} else if (userAgent.contains("android")) {
				if (goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_DOWNLOAD_ALERT_TYPE) && goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_AND_SELECT_TYPE)) {
					dto.setConfirm(true);
				} else {
					dto.setConfirm(false);
				}
				returls = goodOpenUrl.getAndroidDownload();
				if (returls != null && returls.length() > 0) {
					dto.setShowUse(true);
				}
			} else {
				if (!goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_IOS_SELECT_TYPE)) {
					dto.setOpenUrl(true);
				}
				returls = goodOpenUrl.getIosDownload();
				if (returls != null && returls.length() > 0) {
					dto.setShowUse(true);
				}
			}
			// 旧数据
		} else {
			throw new RuntimeGoodsException(ErrorCode.E0404004);
		}

		// 返回详情页
		if (returls == null || returls.length() == 0) {
			returls = "";
			// 露出马上使用按钮
		}
		// 美团特殊加密处理
		if (returls.contains(MEITUAN_URL)) {
			StringBuilder urlParam = new StringBuilder();
			if (!"".equals(returls)) {
				Map<String, String> mapRequest = UrlUtils.uRLRequest(returls);
				// 循环商家URL自带的参数
				for (String strRequestKey : mapRequest.keySet()) {
					if (urlParam.length() == 0) {
						urlParam.append(strRequestKey + "=" + mapRequest.get(strRequestKey));
					} else {
						urlParam.append("&" + strRequestKey + "=" + mapRequest.get(strRequestKey));
					}
				}
			}
			returls = getMeituanUrl(returls, consunmerId, urlParam.toString());
		}
		dto.setSpecialApp(goodOpenUrl.isOpTypeAppItem(TbGoodsOpenUrlDto.SWITCH_GANJI_TYPE));
		dto.setUrl(returls);
		return dto;
	}

}
