/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerGoodsDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月26日下午5:49:07
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;

/**
 * ClassName:PCGSellerGoodsDao <br/>
 * Date:     2016年5月26日 下午5:49:07 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGSellerGoodsDao {

	/**
	 * selectMaxPayloadBySellerId
	 * @param sellerId
	 * @return
	 */
    int selectMaxPayloadBySellerId(long sellerId);
    
    /**
     * insertGoods2Seller
     * @param pcgId
     * @param sellerId
     * @param payload
     * @return
     */
    int insertGoods2Seller(long pcgId,long sellerId,int payload);
    
    /**
     * deleteGoods2Seller
     * @param pcgId
     * @param sellerId
     * @return
     */
    int deleteGoods2Seller(long pcgId,long sellerId);
    
    /**
     * deleteSellerRelation
     * @param sellerId
     * @return
     */
    int deleteSellerRelation(long sellerId);
    
    /**
     * deleteGoodsRelation
     * @param pcgId
     * @return
     */
    int deleteGoodsRelation(long pcgId);
    
    /**
     * selectBySeller
     * @param sellerId
     * @return
     */
    List<PCGSellerGoodsEntity> selectBySeller(long sellerId);
    
    /**
     * selectByGoods
     * @param pcgId
     * @return
     */
    List<PCGSellerGoodsEntity> selectByGoods(long pcgId);
    
    /**
     * 更新一条记录的权重
     * @param sellerId
     * @param pcgId
     * @param payload
     * @return
     */
    public int updatePayload(long sellerId,long pcgId,int payload);
}

