/**
 * Project Name:goods-center-biz
 * File Name:PlatformCouponGoodsDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月19日下午4:57:03
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PlatformCouponGoodsDaoImpl <br/>
 * Date:     2016年5月19日 下午4:57:03 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("platformCouponGoodsDao")
public class PlatformCouponGoodsDaoImpl extends BaseDao implements PlatformCouponGoodsDao{

    
    @Override
    public int insert(PCGInsertDto entity) {
        return getSqlSession().insert(getStamentNameSpace("insert"), entity);
    }

    @Override
    public int markDelete(Long pcgId) {
        return getSqlSession().update(getStamentNameSpace("markDelete"), pcgId);
    }

    @Override
    public int updateStatusOnShelf(Long pcgId) {
        return getSqlSession().update(getStamentNameSpace("updateStatusOnShelf"), pcgId);
    }

    @Override
    public int updateStatusOffShelf(Long pcgId) {
        return getSqlSession().update(getStamentNameSpace("updateStatusOffShelf"),pcgId);
    }
    
    @Override
    public List<PlatformCouponGoodsEntity> selectSearchByName(String namelike) {
        Map<String, Object> params=getBlankParams();
        params.put("name", namelike);
        return getSqlSession().selectList(getStamentNameSpace("selectSearchByName"),params);
    }
    
    @Override
    public int updateEditGoods(Long pcgId, PCGEditDto goods) {
        goods.setPcgId(pcgId);
        return getSqlSession().update(getStamentNameSpace("updateEditGoods"), goods);
    }

    @Override
    public int updateCouponType(Long pcgId, int couponType) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("couponType", couponType);
        return getSqlSession().update(getStamentNameSpace("updateCouponType"), params);
    }
    
    @Override
    public PlatformCouponGoodsEntity selectByPcgId(long pcgId) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        return getSqlSession().selectOne(getStamentNameSpace("selectByPcgId"),params);
    }
    @Override
    public PlatformCouponGoodsEntity selectByPcgIdIncludeDeleted(long pcgId){
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        return getSqlSession().selectOne(getStamentNameSpace("selectByPcgIdIncludeDeleted"),params);
    }
    
    @Override
    public List<PlatformCouponGoodsEntity> selectByIds(List<Long> pcgIds) {
    	if(pcgIds.isEmpty()){
    		return new ArrayList<>();
    	}
        Map<String, Object> params=getBlankParams();
        params.put("pcgIds", pcgIds);
        return getSqlSession().selectList(getStamentNameSpace("selectByIds"),params);
    }
    
    @Override
    public List<PlatformCouponGoodsEntity> selectBySearch(String name, Integer pcgStatus, int start, int limit) {
        Map<String, Object> params=getBlankParams();
        params.put("name", name);
        params.put("pcgStatus", pcgStatus);
        params.put("start", start);
        params.put("limit", limit);
        return getSqlSession().selectList(getStamentNameSpace("selectBySearch"),params);
    }
    
    @Override
    public int selectCountBySearch(String name, Integer pcgStatus) {
        Map<String, Object> params=getBlankParams();
        params.put("name", name);
        params.put("pcgStatus", pcgStatus);
        return getSqlSession().selectOne(getStamentNameSpace("selectCountBySearch"),params);
    }

    @Override
    public int updateSwitches(Long pcgId, Long switches) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("switches", switches);
        return getSqlSession().update(getStamentNameSpace("updateSwitches"),params);
    }
}

