package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.SellerDao;

/**
 * 
 * 商家安全签名
 *
 */
@Repository
public class SellerDaoImpl extends BaseCreditsDao implements SellerDao {

	@Override
	public int insertSeller(SellerDto sellerDto) {
		return getSqlSession().insert(getStamentNameSpace("insert"), sellerDto);
	}

	@Override
	public int deleteSeller(Long id) {
		return getSqlSession().update(getStamentNameSpace("updateStatus"), id);
	}

	@Override
	public List<SellerDto> findAll(SellerDto sellerDto, Integer offset, Integer max) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("offset", offset);
		paramMap.put("max", max);
		paramMap.put("sellerName", sellerDto.getSellerName());
		paramMap.put("validFlag", sellerDto.getValidFlag());
		return getSqlSession().selectList(getStamentNameSpace("findAll"), paramMap);
	}

	@Override
	public Integer findCount(SellerDto sellerDto) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("sellerName", sellerDto.getSellerName());
		paramMap.put("validFlag", sellerDto.getValidFlag());
		return getSqlSession().selectOne(getStamentNameSpace("findCount"), paramMap);
	}

	@Override
	public SellerDto findById(Long id) {
		return getSqlSession().selectOne(getStamentNameSpace("findById"), id);
	}

	@Override
	public int update(SellerDto sellerDto) {
		return getSqlSession().update(getStamentNameSpace("update"), sellerDto);
	}

}
