package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlDto;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.TbGoodsOpenurlDao;

/**
 * 马上使用按钮
 */
@Repository
public class TbGoodsOpenurlDaoImpl extends BaseDao implements TbGoodsOpenurlDao {

	@Override
	public TbGoodsOpenUrlDto findTbGoodsOpenurl(Long gid, Integer gtype) {
		Map<String, Object> paramMap = getBlankParams();
		paramMap.put("gid", gid);
		paramMap.put("gtype", gtype);
		return getSqlSession().selectOne(getStamentNameSpace("findTbGoodsOpenurl"), paramMap);
	}

	@Override
	public void updateTbGoodsOpenurl(TbGoodsOpenUrlDto item) {
		getSqlSession().update(getStamentNameSpace("updateTbGoodsOpenurl"), item);
	}

	@Override
	public void insertTbGoodsOpenurl(TbGoodsOpenUrlDto item) {
		getSqlSession().insert(getStamentNameSpace("insertTbGoodsOpenurl"), item);
	}

}