package cn.com.duiba.goods.center.biz.dao.item;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.AppItemMaskingEntity;

/**
 * AppItemMaskDao
 */
public interface AppItemMaskDao {

	/**
	 * findByItem
	 * @param itemId
	 * @return
	 */
	public AppItemMaskingEntity findByItem(Long itemId);

	/**
	 * delete
	 * @param id
	 */
	public void delete(Long id);

	/**
	 * findAllByApp
	 * @param appId
	 * @return
	 */
	public List<AppItemMaskingEntity> findAllByApp(Long appId);

	/**
	 * findByAppIdAndItemId
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public AppItemMaskingEntity findByAppIdAndItemId(Long appId, Long itemId);

	/**
	 * insert
	 * @param appItemMaskingEntity
	 */
	public void insert(AppItemMaskingEntity appItemMaskingEntity);

	/**
	 * find
	 * @param id
	 * @return
	 */
	public AppItemMaskingEntity find(Long id);

	/**
	 * findItemAppMasking
	 * @param appId
	 * @return
	 */
	public List<Long> findItemAppMasking(Long appId);

}
