package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemLimitDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemLimitDao;

/**
 * 
 * 限量商品兑换明细
 *
 */
@Repository("itemLimitDao")
public class ItemLimitDaoImpl extends BaseCreditsDao implements ItemLimitDao {

	@Override
	public Integer countByItemKeyAndGmtCreate(String itemKey, Date startTime) {
		Map<String, Object> queryMap = getBlankParams();
		queryMap.put("itemKey", itemKey);
		queryMap.put("startTime", startTime);
		return this.getSqlSession().selectOne(getStamentNameSpace("countByItemKeyAndGmtCreate"), queryMap);
	}

	@Override
	public Integer countByItemKey(String itemKey) {
		Map<String, Object> queryMap = getBlankParams();
		queryMap.put("itemKey", itemKey);
		return this.getSqlSession().selectOne(getStamentNameSpace("countByItemKey"), queryMap);
	}

	@Override
	public void insert(ItemLimitDto itemLimit) {
		this.getSqlSession().insert(getStamentNameSpace("insert"), itemLimit);
	}

	@Override
	public int delete(String itemKey, long consumerId, long orderId, String orderType) {
		Map<String, Object> queryMap = getBlankParams();
		queryMap.put("itemKey", itemKey);
		queryMap.put("consumerId", consumerId);
		queryMap.put("sourceId", orderId);
		queryMap.put("sourceType", orderType);
		return this.getSqlSession().delete(getStamentNameSpace("delete"), queryMap);
	}
}
