package cn.com.duiba.goods.center.biz.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
public class AppItemExtraEntity {
    /**
     * 如下静态值作为customPrompts JSON数据的key
     */
    public static final String ACCOUNT_PROMPT = "accountPrompt";//虚拟商品兑换需要输入账号时，输入框中的提示

    private Long id;
    /**
     * 商品id,对应app_item表的id
     */
    private Long appItemId;
    /**
     * 使用提示
     */
    private String usePrompt;
    /**
     * 使用按钮文案
     */
    private String btnText;
    /**
     * 商品定制化提示，数据为json结构
     */
    private String customPrompts;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getUsePrompt() {
        return usePrompt;
    }

    public void setUsePrompt(String usePrompt) {
        this.usePrompt = usePrompt;
    }

    public String getBtnText() {
        return btnText;
    }

    public void setBtnText(String btnText) {
        this.btnText = btnText;
    }

    /**
     * 保留set/get方法是为了使用BeanUtils等工具类的时候方便，强烈建议使用JSON相关的方法
     *
     * @param customPrompts
     */
    public void setCustomPrompts(String customPrompts) {
        this.customPrompts = customPrompts;
    }

    public String getCustomPrompts() {
        return customPrompts;
    }

    /**
     * 获取提示语句的json对象
     *
     * @return
     */
    public JSONObject getCustomPromptsJson() {
        JSONObject json = JSON.parseObject(customPrompts);
        return json == null ? new JSONObject() : json;
    }

    /**
     * 设置定制化提示
     *
     * @param json
     */
    public void setCustomPromptsJson(JSONObject json) {
        if (json != null) {
            this.customPrompts = json.toJSONString();
        }
    }

    /**
     * 通过key获取提示语句
     *
     * @param key
     * @return
     */
    public String getPromptByKey(String key) {
        return getCustomPromptsJson().getString(key);
    }

    /**
     * 设置提示语句
     *
     * @param key
     * @param prompt
     */
    public void setPromptByKey(String key, String prompt) {
        JSONObject json = getCustomPromptsJson();
        json.put(key, prompt);
        this.customPrompts = json.toJSONString();
    }

}
