package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.AddrLimitBO;
import cn.com.duiba.goods.center.biz.service.item.AddrLimitService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Service("remoteAddrLimitService")
public class RemoteAddrLimitServiceImpl implements RemoteAddrLimitService {
	@Autowired
	private AddrLimitBO addrLimitBO;
	@Autowired
	private AddrLimitService addrLimitService;

	@Override
	public DubboResult<List<ItemKeyDto>> getItemCanPassAddrLimit(List<ItemKeyDto> items, String ip) {
		return DubboResult.successResult(addrLimitBO.getItemCanPassAddrLimit(items, ip));
	}

	@Override
	public DubboResult<Boolean> ipValidation(ItemKeyDto itemKeyDto, String ip) {
		Boolean ret = addrLimitBO.ipValidation(itemKeyDto, ip);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<List<AddrLimitDto>> findAddrLimitByGid(GoodsTypeEnum gtype, Long gid) {
		List<AddrLimitDto> ret;
		if (GoodsTypeEnum.APP.getGtype() == gtype.getGtype()) {
			ret = addrLimitService.findAddrLimitByAppItemId(gid);
		} else if (GoodsTypeEnum.DUIBA.getGtype() == gtype.getGtype()) {
			ret = addrLimitService.findAddrLimitByItemId(gid);
		} else {
			return DubboResult.failResult(ErrorCode.E0202008.getDesc());
		}
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> findTypeByGid(GoodsTypeEnum gtype, Long gid) {
		Integer type;
		if (GoodsTypeEnum.APP.getGtype() == gtype.getGtype()) {
			type = addrLimitService.findTypeByAppItemId(gid);
		} else if (GoodsTypeEnum.DUIBA.getGtype() == gtype.getGtype()) {
			type = addrLimitService.findTypeByItemId(gid);
		} else {
			return DubboResult.failResult(ErrorCode.E0202008.getDesc());
		}
		return DubboResult.successResult(type);
	}

	@Override
	public DubboResult<Integer> batchInsertAddrLimit(List<AddrLimitDto> addrLimitList) {
		Integer ret = addrLimitService.batchInsertAddrLimit(addrLimitList);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Integer> deleteAddrLimit(Long itemId, Long appItemId) {
		Integer ret = addrLimitService.deleteAddrLimit(itemId, appItemId);
		return DubboResult.successResult(ret);
	}
}
