/**
 * Project Name:goods-center-biz
 * File Name:RemotePCGCategoryBackendServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.remoteservice.impl
 * Date:2016年5月20日下午1:24:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.slf4j.LoggerFactory;

import cn.com.duiba.goods.center.api.remoteservice.RemotePCGCategoryBackendService;
import cn.com.duiba.goods.center.api.remoteservice.RemotePlatformCouponGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemotePCGCategoryBackendServiceImpl <br/>
 * Date:     2016年5月20日 下午1:24:10 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("remotePCGCategoryBackendService")
public class RemotePCGCategoryBackendServiceImpl implements RemotePCGCategoryBackendService{
    private static Logger log=LoggerFactory.getLogger(RemotePCGCategoryBackendServiceImpl.class);
    @Autowired
    private PCGCategoryGoodsService pcgCategoryGoodsService;
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private RemotePlatformCouponGoodsBackendService remotePlatformCouponGoodsBackendService;
    
    @Override
    public DubboResult<Long> createCategory(String name,Integer payload) {
        try{
            Long id=pcgCategoryGoodsService.addCategory(name,payload);
            return DubboResult.successResult(id);
        }catch(Exception e){
            log.error("createCategory name="+name +", payload="+payload,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteCategory(Long categoryId) {
        try{
            if(pcgCategoryGoodsService.removeCategory(categoryId)){
                return DubboResult.successResult(true);
            }else{
                return DubboResult.failResult("");
            }
        }catch(Exception e){
            log.error("deleteCategory categoryId="+categoryId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<PCGCategoryDto>> findAll() {
        try {
            List<PCGCategoryDto> ret=new ArrayList<>();
            List<PCGCategoryEntity> list=pcgCategoryGoodsService.findAll();
            for(PCGCategoryEntity e:list){
                PCGCategoryDto dto=new PCGCategoryDto();
                dto.setId(e.getId());
                dto.setName(e.getName());
                dto.setPayload(e.getPayload());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("findAll",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<List<PCGCategoryGoodsDto>> findAllByCategoryId(long categoryId) {
        try {
            List<PCGCategoryGoodsDto> ret=new ArrayList<>();
            List<PCGCategoryGoodsEntity> list=pcgCategoryGoodsService.findAllGoodsByCategory(categoryId);
            List<Long> pcgIds=new ArrayList<>();
            for(PCGCategoryGoodsEntity e:list){
                PCGCategoryGoodsDto dto=new PCGCategoryGoodsDto();
                dto.setId(e.getId());
                dto.setCategoryId(e.getCategoryId());
                dto.setPayload(e.getPayload());
                dto.setPcgId(e.getPcgId());
                ret.add(dto);
                pcgIds.add(e.getPcgId());
            }
            if(!pcgIds.isEmpty()){
                Map<Long,  PlatformCouponGoodsEntity> map=platformCouponGoodsService.findByIds(pcgIds);
                for(PCGCategoryGoodsDto dto:ret){
                    dto.setTitle(map.get(dto.getPcgId()).getName());
                }
            }
            
            return DubboResult.successResult(ret);
        } catch (Exception e) {
            log.error("findAllByCategoryId categoryId="+categoryId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Boolean> sortCategories(List<PCGCategoryDto> categories) {
        try {
            pcgCategoryGoodsService.sortCategories(categories);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("sortCategories",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Boolean> sortCategoryGoods(List<PCGCategoryGoodsDto> list) {
        
        try {
            pcgCategoryGoodsService.sortCategoryGoods(list);
            
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("sortCategoryGoods",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    
    @Override
    public DubboResult<Boolean> editCategoryNameAndPayload(Long categoryId,String name,Integer payload) {
        
        try {
            pcgCategoryGoodsService.updateNameAndPayload(categoryId, name, payload);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            log.error("sortCategoryGoods categoryId="+categoryId+",name="+name+",payload="+payload,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> addGoods(long categoryId, long pcgId,Integer payload) {
        try{
            boolean ret=pcgCategoryGoodsService.addGoods2Category(pcgId,categoryId,payload);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("addRelation categoryId="+categoryId+",pcgId="+pcgId+",payload="+payload,e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteGoods(long categoryId, long pcgId) {
        try{
            boolean ret=pcgCategoryGoodsService.removeGoodsFromCategory(pcgId,categoryId);
            return DubboResult.successResult(ret);
        }catch(Exception e){
            log.error("deleteRelation categoryId="+categoryId+",pcgId="+pcgId,e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}

