package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemAppSpecifyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemAppSpecifyService;
import cn.com.duiba.goods.center.biz.service.stock.ItemAppSpecifyService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

/**
 * Created by liuyao on 2017/1/11.
 */
@Service
public class RemoteItemAppSpecifyServiceImpl implements RemoteItemAppSpecifyService {

    @Autowired
    private ItemAppSpecifyService itemAppSpecifyService;

    @Override
    public DubboResult<List<ItemAppSpecifyDto>> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        return DubboResult.successResult(itemAppSpecifyService.findSpecifyByItemIdsAndAppId(itemIds,appId));
    }

    @Override
    public DubboResult<ItemAppSpecifyDto> findByItemIdAndAppId(Long itemId, Long appId){
        return DubboResult.successResult(itemAppSpecifyService.findByItemIdAndAppId(itemId, appId));
    }
}
