package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.bo.AppItemClassifyRelationBO;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * RemoteItemKeyServiceImpl
 */
@Service
public class RemoteItemKeyServiceImpl implements RemoteItemKeyService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemKeyServiceImpl.class);

	@Autowired
	private ItemKeyService itemKeyService;

	@Autowired
	private ItemKeyBo itemKeyBo;

	@Autowired
	private AppItemClassifyRelationBO appItemClassifyRelationBO;

	@Override
	public DubboResult<ItemKeyDto> findItemKey(Long appItemId, Long itemId, Long appId) {
		try {
			ItemKeyDto dto = itemKeyService.findItemKey(appItemId, itemId, appId);
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			LOGGER.error("findItemKey:appItemId=" + appItemId + " itemId=" + itemId + " appId= " + appId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> findStock(ItemKeyDto itemKeyDto) {
		try {
			Long ret = itemKeyService.findStock(itemKeyDto);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("findStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
		try {
			Boolean ret = itemKeyService.consumeStock(itemKeyDto, bizId, bizSource);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("consumeStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
		try {
			Boolean ret = itemKeyService.rollbackStock(itemKeyDto, bizId, bizSource, new Date());
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("rollbackStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}
	
	@Override
	public DubboResult<Boolean> rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource, Date bizDate) {
		try {
			Boolean ret = itemKeyService.rollbackStock(itemKeyDto, bizId, bizSource, bizDate);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("rollbackStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}


	@Override
	public DubboResult<List<ItemKeyDto>> findItemKeyByAppItemIds(List<Long> appItemIds, Long appId) {
		try {
			List<ItemKeyDto> dtos = itemKeyService.findItemKeyByAppItemIds(appItemIds, appId);
			return DubboResult.successResult(dtos);
		} catch (Exception e) {
			LOGGER.error("findItemKeyByAppItemIds:appItemIds=" + appItemIds.toString() + " appId=" + appId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<ItemKeyDto>> findHomeItemKey(Long appId) {
		return DubboResult.successResult(itemKeyBo.findHomeItemKeyCacheList(appId));
	}

	@Override
	public DubboResult<List<ItemKeyDto>> getBatchItemKeyByAppItemIds(List<Long> appItemIds) {
		return DubboResult.successResult(itemKeyBo.getBatchItemKeyByAppItemIds(appItemIds));
	}

	@Override
	public DubboResult<ItemKeyDto> getItemKey(Long appItemId) {
		return DubboResult.successResult(itemKeyBo.getItemKey(appItemId));
	}

	@Override
	public DubboResult<ItemKeyDto> getItemKey(Long appId,Long itemId) {
		return DubboResult.successResult(itemKeyBo.getItemKey(appId,itemId));
	}

	@Override
	public DubboResult<List<ItemKeyDto>> findItemKeysWithClassifyPayLoad(Long appId, Long classifyId, String status) {
		List<AppItemDto> appItems = appItemClassifyRelationBO.findAppItemsWithClassifyPayLoad(classifyId, appId, status);
		return DubboResult.successResult(itemKeyBo.transformAppItemList(appItems));
	}

	@Override
	public DubboResult<ItemKeyDto> findItemKeyIncludeDeleted(Long appItemId, Long itemId, Long appId) {
		try {
			ItemKeyDto dto = itemKeyService.findItemKeyIncludeDeleted(appItemId, itemId, appId);
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			LOGGER.error("findItemKeyIncludeDeleted:appItemId=" + appItemId + " itemId=" + itemId + " appId=" + appId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

}
