package cn.com.duiba.goods.center.biz.remoteservice.item;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemotePreStockService;
import cn.com.duiba.goods.center.biz.bo.CreditsCalculateBo;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 2017/1/11.
 */
@Service
public class RemotePreStockServiceImpl implements RemotePreStockService {

	@Autowired
	private PreStockService preStockService;
	@Autowired
	private CreditsCalculateBo creditsCalculateBo;

	@Override
	public DubboResult<List<PreStockDto>> findAllPreStock(List<Long> itemIds, Long appId) {
		return DubboResult.successResult(preStockService.findAllPreStock(itemIds, appId));
	}

	@Override
	public DubboResult<Long> calculateCreditsByItemKeyAndDegree(ItemKeyDto key, String degree, Long appRate) {
		return DubboResult.successResult(creditsCalculateBo.calculateCreditsByItemKeyAndDegree(key, degree, appRate));
	}
}
