/**
 * Project Name:goods-center-biz
 * File Name:GoodsDirectionalConfigService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年6月28日上午11:16:50
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.impl.GoodsDirectionalConfigServiceImpl.DayLimitConfig;

/**
 * ClassName:GoodsDirectionalConfigService <br/>
 * Date:     2016年6月28日 上午11:16:50 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsDirectionalConfigService {
    /**
     * 
     * find:根据id查询定向表. <br/>=
     *
     * @author duiba
     * @param id
     * @return
     * @since JDK 1.6
     */
    GoodsDirectionalConfigEntity find(long id);
    /**
     * 
     * findByGoods:根据商品类型、商品id查询. <br/>
     *
     * @author wubo
     * @param gtype
     * @param goodsId
     * @return
     * @since JDK 1.6
     */
    List<GoodsDirectionalConfigEntity> findByGoods(GoodsTypeEnum gtype,long goodsId);
    
    /**
     * 
     * findByGoodsAll:根据商品类型、商品列表查询. <br/>
     *
     * @author wubo
     * @param gtype
     * @param goodss
     * @return
     * @since JDK 1.6
     */
    Map<String, GoodsDirectionalConfigEntity> findByGoodsAll(GoodsTypeEnum gtype,List<Long> goodss);
    
    /**
     * 查询定向配置<br/>
     * 如果单个定向配置没有，自动查询共享配置返回<br/>
     * @author xuhengfei
     * @param gtype
     * @param goodsId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    GoodsDirectionalConfigEntity findByGoodsAndAppIncludeShared(GoodsTypeEnum gtype,long goodsId,long appId);
    /**
     * 
     * findByGoodsAndApp:根据商品类型、商品id、appid查询. <br/>
     *
     * @author wubo
     * @param gtype
     * @param goodsId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    GoodsDirectionalConfigEntity findByGoodsAndApp(GoodsTypeEnum gtype,long goodsId,long appId);
    /**
     * 查找商品的定向共享配置
     *
     * @author xuhengfei
     * @param gtype
     * @param goodsId
     * @return
     * @since JDK 1.6
     */
    GoodsDirectionalConfigEntity findSharedByGoods(GoodsTypeEnum gtype,long goodsId);
    /**
     * add:添加. <br/>
     *
     * @author wubo
     * @param entity
     * @return
     * @since JDK 1.6
     */
    boolean add(GoodsDirectionalConfigEntity entity);
    /**
     * update
     * @param id
     * @param stockId
     * @param dayLimit
     * @param minPrice
     * @return
     */
    boolean update(long id,Long stockId,Integer dayLimit,Integer minPrice);
    /**
     * remove:删除. <br/>
     *
     * @author wubo
     * @param id
     * @return
     * @since JDK 1.6
     */
    boolean remove(long id);
    /**
     * 查询App中一个商品的每日限量值
     * null表示无限量
     *
     * @author xuhengfei
     * @param gtype
     * @param goodsId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DayLimitConfig getDayLimit(GoodsTypeEnum gtype,long goodsId,long appId);
}

