/**
 * Project Name:goods-center-biz
 * File Name:GoodLimitRecordService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年6月28日上午10:46:17
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;

/**
 * ClassName:GoodLimitRecordService <br/>
 * Function: 兑换限制记录表 <br/>
 * Date:     2016年6月28日 上午10:46:17 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsLimitRecordService {
    /**
     * 查询已经兑换的次数
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    int findCount(int gtype,long gid,long consumerId);
    /**
     * 插入一条兑换记录
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param consumerId
     * @since JDK 1.6
     */
    void addRecord(int gtype,long gid,long consumerId);
    /**
     * 回滚一个兑换记录
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param consumerId
     * @since JDK 1.6
     */
    void rollbackRecord(int gtype,long gid,long consumerId);
    /**
     * 批次查询已经兑换的次数
     * @param gtype
     * @param gids
     * @param consumerId
     * @return
     */
    List<GoodsLimitRecordEntity> findCounts(int gtype, List<Long> gids, long consumerId);
}

