/**
 * Project Name:goods-center-biz
 * File Name:PCGCategoryGoodsService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年5月26日下午6:51:02
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryGoodsDto;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;


/**
 * ClassName:PCGCategoryGoodsService <br/>
 * Date:     2016年5月26日 下午6:51:02 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGCategoryGoodsService {
    

    /**
     * 创建一个分类
     * @param name
     * @param payload
     * @return
     */
    Long addCategory(String name,Integer payload);
    /**
     * 修改一个分类的名称
     * @param id
     * @param name
     * @param payload
     */
    void updateNameAndPayload(Long id,String name,Integer payload);
    /**
     * 修改一个分类的权重
     * @param id
     * @param payload
     */
    void updateCategoryPayload(Long id,int payload);
    /**
     * 查询所有分类
     * @return
     */
    List<PCGCategoryEntity> findAll();
    /**
     * 
     * select:单条记录查询. <br/>
     *
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    PCGCategoryEntity findCategory(Long id);
    /**
     * 将商品添加到分类中
     *
     * @author xuhengfei
     * @param pcgId
     * @param categoryId
     * @param payload 
     * @return
     * @since JDK 1.6
     */
    Boolean addGoods2Category(long pcgId,long categoryId, Integer payload);
    /**
     * 将商品从分类中删除
     *
     * @author xuhengfei
     * @param pcgId
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    Boolean removeGoodsFromCategory(long pcgId,long categoryId);
    /**
     * 删除一个分类
     *
     * @author xuhengfei
     * @param categoryId
     * @return
     * @since JDK 1.6
     */
    Boolean removeCategory(long categoryId);
    
    /**
     * 如果一个商品被删除，这个商品相关的类目关系都需要删除
     *
     * @author xuhengfei
     * @param pcgId
     * @return
     * @since JDK 1.6
     */
    Boolean deleteAllByPcgId(long pcgId);
    
    /**
     * findAllGoodsByCategory
     * @param categoryId
     * @return
     */
    List<PCGCategoryGoodsEntity> findAllGoodsByCategory(long categoryId);
    
    /**
     * 对类目进行批量排序
     *
     * @author xuhengfei
     * @param categories
     * @since JDK 1.6
     */
    void sortCategories(List<PCGCategoryDto> categories);
    /**
     * 对类目下的商品进行批量排序
     *
     * @author xuhengfei
     * @param list
     * @since JDK 1.6
     */
    void sortCategoryGoods(List<PCGCategoryGoodsDto> list);
    
    /**
     * findAllGoodsByCateIds
     * @param catIds
     * @return
     */
	List<PCGCategoryGoodsEntity> findAllGoodsByCateIds(List<Long> catIds);
}

