package cn.com.duiba.goods.center.biz.service;


/**
 * REDIS服务类
 */
public interface RedisCacheService {
	
	/**
	 * 查询缓存
	 * @param key
	 * @return
	 */
	public <T> T getObject(String key);
	
	/**
	 * 设置缓存
	 * @param key
	 * @param value
	 * @param seconds
	 */
	public void setObject(String key, Object value, int seconds);
	
	
	/**
	 * 查询缓存
	 * @param key 缓存key
	 * @return
	 */
	public String get(String key);
	
	/**
	 * 设置缓存
	 * @param key 缓存key
	 * @param value 缓存内存
	 * @param seconds 失效时间秒 
	 */
	public void set(String key, String value, int seconds);
	
	/**
	 * 删除key
	 * @param key
	 */
	public void delete(String key);
	
	/**
	 * 获取一个分布式锁 <br/>
	 * @param key
	 * @param seconds
	 */
	public boolean getLock(String key, int seconds);
	
	/**
	 * 获取一个分布式锁 <br/>
	 * 没有获取到等待20ms重试获取最多重试20次
	 * 
	 * @param key 锁的唯一key
	 * @param seconds 锁失效时间
	 * @return
	 */
	public boolean tryGetLock(String key, int seconds);
	
	/**
	 * 释放锁
	 * @param key
	 */
	public void releaseLock(String key);
	
	/**
	 * 获取队列大小
	 * @param key
	 * @return
	 */
	public Long getQueueSize(String key);
	
	/**
	 * 从队列中取第一个数据
	 * 
	 * @param key
	 * @return
	 */
	public String pop(String key);
	
	/**
	 * 添加到队列
	 * 
	 * @param values
	 */
	public void addQueue(String key, String[] values, int seconds);

}
