package cn.com.duiba.goods.center.biz.service.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

/**
 * AppItemService
 */
public interface AppItemService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public AppItemEntity find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public List<AppItemEntity> findByIds(List<Long> ids);

	/**
	 * 根据ItemId查询
	 * 
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId);

	/**
	 * 创建商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public Long insert(AppItemEntity appItemEntity);

	/**
	 * 修改商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public Boolean update(AppItemEntity appItemEntity);

	/**
	 * 删除商品
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public Boolean delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public Integer deleteByIds(Long appId, List<Long> appItemId);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Boolean updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 减一个库存
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public Boolean decrStock(Long appId, Long appItemId);

	/**
	 * 增加一个库存
	 * 
	 * @param appItemId
	 * @param bizId
	 * @return
	 */
	public Boolean incrStock(Long appItemId);

	/**
	 * 编辑商品，增加库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public Boolean appendStock(Long appId, Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public Boolean deductStock(Long appId, Long appItemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public int updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate);
	
	/**
	 * 修改EXPIED为null
	 * 
	 * @param itemId
	 * @return
	 */
	public int updateExpiedAppItem(Long itemId);

	/**
	 * 修改EXPIED为null
	 * 
	 * @param appItemId
	 * @return
	 */
	public int updateExpiedAppItemById(Long appItemId);
	
	/**
	 * 查询appIds根据活动id
	 * @param activityId
	 * @param type
	 * @return
	 */
	List<Long> findAppIdsByInActivityId(Long activityId, Integer type);

	/**
	 * 查询appIds根据活动id
	 * @param relationId
	 * @return
	 */
    List<Long> findAppIdsByActivityId(Long relationId);

    /**
     * 根据兑吧商品ID批量查询APPID
     * @param longs
     * @return
     */
    List<Long> findAppIdByItemIds(List<Long> longs);

    /**
     * 批量查询APPID
     * @param longs
     * @return
     */
    List<Long> findAppIdsByIds(List<Long> longs);
    
    /**
     * 清理缓存
     * @param appItemId
     */
    public void removeCache(Long appItemId);

    /**
     * 修改状态根据SourceRelationId;
     * @param status
     * @param delete
     * @param oids
     * @return
     */
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);
    
    /**
     * 根据SourceIds和SourceTypes批量查询AppItemId
     * @param sourceIds
     * @param sourceTypes
     * @return
     */
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes);
}
