package cn.com.duiba.goods.center.biz.service.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.common.GoodsException;

/**
 * 
 * ItemKeyStockService
 *
 */
public interface ItemKeyStockService {

	/**
	 * 扣商品库存
	 * @param itemKeyDto
	 * @param bizId
	 * @param bizSource
	 * @return
	 * @throws GoodsException
	 */
	public Boolean decrStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) throws GoodsException;

	/**
	 * 扣商品定向APP库存
	 * @param appId
	 * @param itemEntity
	 * @param bizId
	 * @param bizSource
	 * @return
	 * @throws GoodsException
	 */
	public Boolean decrAppSpecifyStock(Long appId, ItemEntity itemEntity, String bizId, String bizSource) throws GoodsException;

	/**
	 * 扣商品预分配库存
	 * @param appId
	 * @param itemId
	 * @param pointStock
	 * @param bizId
	 * @param bizSource
	 * @return
	 * @throws GoodsException
	 */
	public Boolean decrPreStock(Long appId, Long itemId, PreStockPointEntity pointStock, String bizId, String bizSource) throws GoodsException;

	/**
	 * 扣每日限量库存
	 * @param itemKeyDto
	 * @return
	 */
	public Boolean decrEverydayStock(ItemKeyDto itemKeyDto) throws GoodsException;

	/**
	 * 返还商品库存
	 * @param bizId
	 * @param bizSource
	 * @return
	 */
	public Boolean rollbackStock(String bizId, String bizSource);

	/**
	 * 返还商品定向APP库存
	 * @param bizId
	 * @param bizSource
	 * @return
	 */
	public Boolean rollbackAppSpecifyStock(String bizId, String bizSource);

	/**
	 * 商品预分配库存
	 * @param bizId
	 * @return
	 */
	public Boolean rollbackPreStock(String bizId);

	/**
	 * 返还每日限量库存
	 * @param itemKeyDto
	 * @return
	 */
	public Boolean rollbackEverydayStock(ItemKeyDto itemKeyDto);

}
