package cn.com.duiba.goods.center.biz.service.item;

import java.util.Date;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemLimitDto;

/**
 * 限量商品兑换明细
 */
public interface ItemLimitService {

	/**
	 * 统计限量商品兑换明细次数
	 * 
	 * @param itemKey
	 * @param startTime
	 * @return
	 */
	public Integer countByItemKeyAndGmtCreate(String itemKey, Date startTime);

	/**
	 * 统计限量商品兑换明细次数
	 * 
	 * @param itemKey
	 * @return
	 */
	public Integer countByItemKey(String itemKey);

	/**
	 * 记录限量商品兑换明细
	 * 
	 * @param itemLimitDO
	 */
	public void insert(ItemLimitDto itemLimit);

	/**
	 * 删除限量商品兑换明细
	 * 
	 * @param itemKey
	 * @param consumerId
	 * @param orderId
	 * @param orderType
	 */
	public int delete(String itemKey, long consumerId, long orderId, String orderType);

}
