package cn.com.duiba.goods.center.biz.service.item.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemLimitDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemLimitDao;
import cn.com.duiba.goods.center.biz.service.item.ItemLimitService;

/**
 * 限量商品兑换明细
 */
@Service
public class ItemLimitServiceImpl implements ItemLimitService {

	@Autowired
	private ItemLimitDao itemLimitDao;

	@Override
	public Integer countByItemKeyAndGmtCreate(String itemKey, Date startTime) {
		return itemLimitDao.countByItemKeyAndGmtCreate(itemKey, startTime);
	}

	@Override
	public Integer countByItemKey(String itemKey) {
		return itemLimitDao.countByItemKey(itemKey);
	}

	@Override
	public void insert(ItemLimitDto itemLimit) {
		itemLimitDao.insert(itemLimit);
	}

	@Override
	public int delete(String itemKey, long consumerId, long orderId, String orderType) {
		return itemLimitDao.delete(itemKey, consumerId, orderId, orderType);
	}

}
