/**
 * Project Name:goods-center-biz
 * File Name:StockServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.stock.impl
 * Date:2016年6月28日下午2:46:30
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.stock.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

/**
 * ClassName:StockServiceImpl <br/>
 * Date:     2016年6月28日 下午2:46:30 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("stockService")
public class StockServiceImpl implements StockService{
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteStockService remoteStockService;
    
	@Override
	public List<Long> getNeedCountDownOtherStockIds(int gtype, long gid, long appId) {
		// 1.判断 GoodsTypeEnum.PLATFORM 商品是否扣共享库存，定向库存
		if (gtype == GoodsTypeEnum.PLATFORM.getGtype()) {
			try {
				DBTimeProfile.enter("getNeedCountDownOtherStockIds");
				List<Long> stockIds = new ArrayList<>();
				GoodsDirectionalConfigEntity config = goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.getGoodsTypeEnum(gtype), gid, appId);
				if (config == null) {
					// 1.1.定向共享库存
					config = goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.getGoodsTypeEnum(gtype), gid);
					if (config != null) {
						stockIds.add(config.getStockId());
					}
				} else {
					// 1.2.定向库存
					stockIds.add(config.getStockId());
				}
				return stockIds;
			} finally {
				DBTimeProfile.release();
			}
		}
		return new ArrayList<>();
	}

	@Override
	public Map<Long, StockDto> findStockByStockIds(List<Long> stockIds) {
		try {
			DBTimeProfile.enter("findStockByStockIds stockIds size=" + (stockIds.isEmpty() ? 0 : stockIds.size()));
			Map<Long, StockDto> stockMap = new HashMap<>();
			if (stockIds.isEmpty()) {
				return stockMap;
			}
			DubboResult<List<StockDto>> ret = remoteStockService.findBatchByIds(stockIds);
			if (!ret.isSuccess()) {
				throw new RuntimeGoodsException(ErrorCode.E0203003);
			}
			List<StockDto> stocks = ret.getResult();
			for (StockDto dto : stocks) {
				stockMap.put(dto.getStockID(), dto);
			}
			return stockMap;
		} finally {
			DBTimeProfile.release();
		}
	}

	@Override
	public StockDto findStock(Long stockId) {
		DubboResult<StockDto> ret = remoteStockService.findDto(stockId);
		if (!ret.isSuccess()) {
			throw new RuntimeGoodsException(ErrorCode.E0203003);
		}
		return ret.getResult();
	}
	
	@Override
	public Map<Long, StockDto> findGoodsBatchStocks(List<GoodsBatchEntity> batchs) {
		try {
			DBTimeProfile.enter("findGoodsBatchStocks");
			Map<Long, StockDto> stockMap = new HashMap<>();
			if (batchs == null || batchs.isEmpty()) {
				return stockMap;
			}
			List<Long> stockIds = new ArrayList<>();
			for (GoodsBatchEntity e : batchs) {
				stockIds.add(e.getStockId());
			}
			DubboResult<List<StockDto>> ret = remoteStockService.findBatchByIds(stockIds);
			if (!ret.isSuccess()) {
				throw new RuntimeGoodsException(ErrorCode.E0203003);
			}
			List<StockDto> stocks = ret.getResult();
			for (StockDto dto : stocks) {
				stockMap.put(dto.getStockID(), dto);
			}
			return stockMap;
		} finally {
			DBTimeProfile.release();
		}
	}

}

