package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;

import cn.com.duiba.goods.center.biz.entity.ItemStockConsumeEntity;

/**
 * 
 * ItemStockConsumeDao
 *
 */
public interface ItemStockConsumeDao {

	/**
	 * insert
	 * @param itemStockConsumeEntity
	 * @return
	 */
	public int insert(ItemStockConsumeEntity itemStockConsumeEntity);
	
	/**
	 * countConsumeStockLock
	 * @param relationId
	 * @param relationType
	 * @param time
	 * @return
	 */
	public int countConsumeStockLock(Long relationId, String relationType, Date time);
	
	/**
	 * countAppConsumeStockLock
	 * @param relationId
	 * @param relationType
	 * @param appId
	 * @param time
	 * @return
	 */
	public int countAppConsumeStockLock(Long relationId, String relationType, Long appId, Date time);
	
	/**
	 * findByBizIdAndSource
	 * @param bizId
	 * @param bizSource
	 * @return
	 */
	public ItemStockConsumeEntity findByBizIdAndSource(String bizId, String bizSource);
}
