/**
 * Project Name:goods-center-biz File Name:RemoteGoodsCouponBackendService.java Package
 * Name:cn.com.duiba.goods.center.biz.remoteservice.impl Date:2016年5月23日上午10:51:17 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsCouponBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchImportLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

/**
 * ClassName:RemoteGoodsCouponBackendService <br/>
 * Date: 2016年5月23日 上午10:51:17 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
@Service("remoteGoodsCouponBackendService")
public class RemoteGoodsCouponBackendServiceImpl implements RemoteGoodsCouponBackendService {

	private static Logger log = LoggerFactory.getLogger(RemoteGoodsCouponBackendServiceImpl.class);

	@Autowired
	private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
	@Autowired
	private GoodsBatchService goodsBatchService;
	@Autowired
	private GoodsCouponService goodsCouponService;

	@Override
	public DubboResult<Long> createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) {
		try {
			if(start == null || end == null){
				throw new GoodsException(ErrorCode.E0404006);
			}
			Long batchId = goodsBatchCouponBackendBO.createNormalBatch(gtype, gid, start, end);
			return DubboResult.successResult(batchId);
		} catch (GoodsException e) {
			log.warn("createNormalBatch gtype=" + gtype + ", gid= " + gid + ", start= " + start + ", end=" + end + " message:" + e.getMessage());
			return DubboResult.failResult(e.getMessage());
		} catch (Exception e) {
			log.error("createNormalBatch gtype=" + gtype + " , gid=  " + gid + ", start= " + start + ", end=" + end, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String link, long stock) {
		try {
			if (start == null || end == null) {
				throw new GoodsException(ErrorCode.E0404006);
			}
			if (StringUtils.isEmpty(link)) {
				throw new GoodsException(ErrorCode.E0404007);
			}
			if (stock < 1) {
				throw new GoodsException(ErrorCode.E0404009);
			}
			Long batchId = goodsBatchCouponBackendBO.createLinkBatch(gtype, gid, start, end, link, stock);
			return DubboResult.successResult(batchId);
		} catch (GoodsException e) {
			log.warn("createLinkBatch gtype=" + gtype + ", gid = " + gid + ", start=" + start + ", end= " + end + ",link= " + link + ",stock=" + stock + " message: " + e.getMessage());
			return DubboResult.failResult(e.getMessage());
		} catch (Exception e) {
			log.warn("createLinkBatch gtype=" + gtype + ", gid =" + gid + ", start=" + start + ", end =" + end + ",link=" + link + ",stock=" + stock + " error:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String code, String password, long stock) {
		try {
			if (start == null || end == null) {
				throw new GoodsException(ErrorCode.E0404006);
			}
			if (StringUtils.isEmpty(code)) {
				throw new GoodsException(ErrorCode.E0404008);
			}
			if (stock < 1) {
				throw new GoodsException(ErrorCode.E0404009);
			}
			Long batchId = goodsBatchCouponBackendBO.createRepeatBatch(gtype, gid, start, end, code, password, stock);
			return DubboResult.successResult(batchId);
		} catch (GoodsException e) {
			log.warn("createRepeatBatch gtype=" + gtype + ", gid=" + gid + ",start=" + start + ",end=" + end + ", code=" + code + ",password = " + password + ",stock =" + stock + " message:" + e.getMessage());
			return DubboResult.failResult(e.getMessage());
		} catch (Exception e) {
			log.error("createRepeatBatch gtype=" + gtype + ", gid=" + gid + ",start=" + start + ",end=" + end + ", code=" + code + ",password=" + password + ",stock= " + stock, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link, long changeStock) {
		try {
			if (StringUtils.isEmpty(link)) {
				throw new GoodsException(ErrorCode.E0404007);
			}
			if (changeStock < 0) {
				throw new GoodsException(ErrorCode.E0404009);
			}
			boolean success = goodsBatchCouponBackendBO.updateLinkBatch(gtype, gid, batchId, link, changeStock);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("updateLinkBatch gtype=" + gtype + ",gid =" + gid + ", batchId=" + batchId + ",link=" + link + ",changeStock=" + changeStock, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password, long changeStock) {
		try {
			if (StringUtils.isEmpty(code)) {
				throw new GoodsException(ErrorCode.E0404008);
			}
			if (changeStock < 0) {
				throw new GoodsException(ErrorCode.E0404009);
			}
			boolean success = goodsBatchCouponBackendBO.updateRepeatBatch(gtype, gid, batchId, code, password, changeStock);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("updateRepeatBatch gtype=" + gtype + ",gid= " + gid + ",batchId =" + batchId + ",code=" + code + ",password=" + password + ",changeStock=" + changeStock, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<GoodsBatchDto>> findBatchs(GoodsTypeEnum gtype, long gid) {
		try {
			List<GoodsBatchDto> ret = goodsBatchCouponBackendBO.findBatchs(gtype, gid);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("findBatchs gtype=" + gtype + ", gid= " + gid, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> importNormalCoupons(final GoodsTypeEnum gtype, final long gid, final Long batchId, final String downloadUrl) {
		try {
			if (gtype == null || batchId == null || StringUtils.isEmpty(downloadUrl)) {
				throw new RuntimeGoodsException(ErrorCode.E0404004);
			}
			Long importLogId = goodsBatchCouponBackendBO.importNormalCoupons(gtype, gid, batchId, downloadUrl);
			return DubboResult.successResult(importLogId);
		} catch (RuntimeGoodsException e){
			log.warn("importNormalCoupons gtype=" + gtype + " ,gid=" + gid + ",batchId=  " + batchId + ",downloadUrl=" + downloadUrl + "message:" + e.getMessage());
			return DubboResult.failResult(e.getMessage());
		} catch (Exception e) {
			log.error("importNormalCoupons gtype=" + gtype + " ,gid=" + gid + ",batchId= " + batchId + ",downloadUrl=" + downloadUrl, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<GoodsBatchImportLogDto> findBatchImportLog(Long goodsBatchImportLogId) {
		try {
			GoodsBatchImportLogDto dto = goodsBatchCouponBackendBO.findBatchImportLog(goodsBatchImportLogId);
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			log.error("findBatchImportLog goodsBatchImportLogId=" + goodsBatchImportLogId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
		try {
			boolean success = goodsBatchCouponBackendBO.deleteBatch(gtype, gid, batchId);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("deleteBatch gtype=" + gtype + " , gid=" + gid + ", batchId=" + batchId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<GoodsBatchDto> findBatchStock(GoodsTypeEnum gtype, long gid, long batchId) {
		try {
			GoodsBatchDto stock = goodsBatchCouponBackendBO.findBatchStock(gtype, gid, batchId);
			return DubboResult.successResult(stock);
		} catch (Exception e) {
			log.error("findBatchStock gtype=" + gtype + ",gid = " + gid + " , batchId=" + batchId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Page<GoodsCouponDto>> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex) {
		try {
			Page<GoodsCouponDto> ret = goodsBatchCouponBackendBO.findPage(gtype, gid, batchId, pageSize, pageIndex);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("findPage gtype=" + gtype.getGtype() + ", gid =" + gid + ",batchId =" + batchId + ",pageSize=" + pageSize + ",pageIndex=" + pageIndex, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<GoodsCouponDto>> findCouponByCode(GoodsTypeEnum gtype, long gid, long batchId, String code) {
		try {
			List<GoodsCouponDto> list = goodsBatchCouponBackendBO.findCouponByCode(gtype, gid, batchId, code);
			return DubboResult.successResult(list);
		} catch (Exception e) {
			log.error("findCouponByCode gtype=" + gtype.getGtype() + ",gid = " + gid + ",batchId= " + batchId + ",code=" + code, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId) {
		try {
			Boolean success = goodsBatchCouponBackendBO.deleteBatchUnusedCoupons(gtype, gid, batchId);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("deleteBatchUnusedCoupons gtype=" + gtype.getGtype() + " ,gid= " + gid + ",batchId=" + batchId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> deleteUnusedCoupon(GoodsTypeEnum gtype, long gid, Long couponId) {
		try {
			GoodsCouponDto dto = goodsBatchCouponBackendBO.findCoupon(gtype, gid, couponId);
			Boolean success = goodsBatchCouponBackendBO.deleteUnusedCoupon(gtype, gid, couponId, dto.getGoodsBatchId());
			if (success) {
				return DubboResult.successResult(true);
			} else {
				return DubboResult.failResult("处理失败");
			}
		} catch (Exception e) {
			log.error("deleteUnusedCoupon gtype=" + gtype.getGtype() + " , gid=" + gid + ",couponId=" + couponId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype, long gid, long couponId) {
		try {
			GoodsCouponDto dto = goodsBatchCouponBackendBO.findCoupon(gtype, gid, couponId);
			if (dto == null) {
				return DubboResult.failResult("不存在");
			}
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			log.error("findCoupon gtype=" + gtype.getGtype() + ",gid =" + gid + ",couponId=" + couponId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<GoodsCouponDto>> findUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, int limit) {
		try {
			List<GoodsCouponDto> dtos = goodsBatchCouponBackendBO.findUnusedCoupons(gtype, gid, batchId, limit);
			return DubboResult.successResult(dtos);
		} catch (Exception e) {
			log.error("findUnusedCoupons gtype=" + gtype.getGtype() + ",gid=" + gid, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, List<Long> couponIds) {
		try {
			boolean ret = goodsBatchCouponBackendBO.deleteBatchUnusedCoupons(gtype, gid, batchId, couponIds);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.error("deleteBatchUnusedCoupons gtype=" + gtype.getGtype() + ",gid=" + gid + ",batchId=" + batchId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<List<ACGStockDto>> batchFindGoodsStock(GoodsTypeEnum gtype, List<Long> acgIds) {
		try {
			DBTimeProfile.enter("batchFindGoodsStock");
			List<ACGStockDto> result = new ArrayList<>();
			if (CollectionUtils.isEmpty(acgIds)) {
				return DubboResult.successResult(result);
			}
			result = goodsBatchService.findStockByGids(gtype, acgIds);
			return DubboResult.successResult(result);
		} catch (Exception e) {
			log.error("batchFindACGStock failed, the req=[{}]", acgIds, e);
			return DubboResult.failResult(e.getMessage());
		} finally {
			DBTimeProfile.release();
		}
	}

	@Override
	public DubboResult<ACGStockDto> findGoodsStock(GoodsTypeEnum gtype, Long acgId) {
		try {
			ACGStockDto aCGStockDto = goodsBatchService.findStockByGid(gtype, acgId);
			return DubboResult.successResult(aCGStockDto);
		} catch (Exception e) {
			log.error("batchFindACGStock failed, the req=[{}]", acgId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> updateValidDate(GoodsTypeEnum gtype, long acgId, long batchId, Date startDay, Date endDay) {
		try {
			if (startDay == null || endDay == null) {
				throw new GoodsException(ErrorCode.E0404006);
			}
			boolean success = goodsBatchService.updateValidDate(gtype, acgId, batchId, startDay, endDay);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("updateValidDate failed, the gtype=[{}], the acgId=[{}], the batchId=[{}], the startDay=[{}], the endDay=[{}]", gtype, acgId, batchId, startDay, endDay, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> deleteGoodsCoupon(GoodsTypeEnum gtype, long acgId, long batchId) {

		try {
			boolean success = goodsCouponService.deleteGoodsCoupon(gtype, acgId, batchId);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("deleteGoodsCoupon failed, the gtype=[{}], the acgId=[{}], the batchId=[{}]", gtype, acgId, batchId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> physicalDeleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {

		try {
			boolean success = goodsBatchService.physicalDeleteBatch(gtype, gid, batchId);
			return DubboResult.successResult(success);
		} catch (Exception e) {
			log.error("physicalDeleteBatch failed, the gtype=[{}], the gid=[{}], the batchId=[{}]", gtype, gid, batchId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

}
