package cn.com.duiba.goods.center.biz.util;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复
 * 
 * @author houwen
 */
public enum RedisKeyFactory {
	/** 商品批次列表缓存 */
	K201,
	/** 商品批次切换分布式锁 */
	K202,
	/** IP地址缓存**/
	K203,
	/** 回收券码分布式锁*/
	K204,
	/** 重复券链接券缓存*/
	K205,
	/** 自动推荐缓存*/
	K206,
	;

	/**
	 * 应用名称
	 */
	private static final String SPACE = "GC";

	/**
	 * 拼接key前置
	 */
	public String toString() {
		return SPACE + "_" + super.toString() + "_";
	}

}