package cn.com.duiba.goods.center.biz.bo.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.biz.bo.GoodsBackendBO;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;

/**
 * goodsBackendBO
 */
@Service("goodsBackendBO")
public class GoodsBackendBOImpl implements GoodsBackendBO{
	
	@Autowired
	private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
	@Autowired
	private GoodsBatchService goodsBatchService;

	@Override
	public GoodsStockDto findGoodsStock(GoodsTypeEnum gtype, long gid) {
		ACGStockDto stock = goodsBatchService.findStockByGid(gtype, gid);
		GoodsStockDto dto = new GoodsStockDto();
		dto.setGid(gid);
		dto.setGtype(gtype);
		dto.setStock(stock.getStock());
		dto.setTotalStock(stock.getTotalStock());
		return dto;
	}

}
